/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import jugglinglab.curve.Curve;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;

public class LineCurve
extends Curve {
    protected int n;
    protected double[][] a;
    protected double[][] b;
    protected double[] durations;

    @Override
    public void initCurve(String string) {
    }

    @Override
    public void calcCurve() throws JuggleExceptionInternal {
        this.n = this.numpoints - 1;
        if (this.n < 1) {
            throw new JuggleExceptionInternal("lineCurve error 1");
        }
        this.a = new double[this.n][3];
        this.b = new double[this.n][3];
        this.durations = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.durations[i] = this.times[i + 1] - this.times[i];
            if (!(this.durations[i] < 0.0)) continue;
            throw new JuggleExceptionInternal("lineCurve error 2");
        }
        double[] dArray = new double[this.n + 1];
        for (int i = 0; i < 3; ++i) {
            int n;
            for (n = 0; n < this.n + 1; ++n) {
                dArray[n] = this.positions[n].getIndex(i);
            }
            for (n = 0; n < this.n; ++n) {
                this.a[n][i] = dArray[n];
                this.b[n][i] = (dArray[n + 1] - dArray[n]) / this.durations[n];
            }
        }
    }

    @Override
    public void getCoordinate(double d, Coordinate coordinate) {
        int n;
        if (d < this.times[0] || d > this.times[this.n]) {
            return;
        }
        for (n = 0; n < this.n && !(d <= this.times[n + 1]); ++n) {
        }
        if (n == this.n) {
            n = this.n - 1;
        }
        coordinate.setCoordinate(this.a[n][0] + (d -= this.times[n]) * this.b[n][0], this.a[n][1] + d * this.b[n][1], this.a[n][2] + d * this.b[n][2]);
    }

    @Override
    protected Coordinate getMax2(double d, double d2) {
        if (d2 < this.times[0] || d > this.times[this.n]) {
            return null;
        }
        Coordinate coordinate = null;
        double d3 = Math.max(this.times[0], d);
        double d4 = Math.min(this.times[this.n], d2);
        coordinate = this.check(coordinate, d3, true);
        coordinate = this.check(coordinate, d4, true);
        for (int i = 0; i <= this.n; ++i) {
            double d5;
            double d6;
            if (d3 <= this.times[i] && this.times[i] <= d4) {
                coordinate = this.check(coordinate, this.times[i], true);
            }
            if (i == this.n || !((d6 = Math.max(d3, this.times[i])) < (d5 = Math.min(d4, this.times[i + 1])))) continue;
            coordinate = this.check(coordinate, d6, true);
            coordinate = this.check(coordinate, d5, true);
        }
        return coordinate;
    }

    @Override
    protected Coordinate getMin2(double d, double d2) {
        if (d2 < this.times[0] || d > this.times[this.n]) {
            return null;
        }
        Coordinate coordinate = null;
        double d3 = Math.max(this.times[0], d);
        double d4 = Math.min(this.times[this.n], d2);
        coordinate = this.check(coordinate, d3, false);
        coordinate = this.check(coordinate, d4, false);
        for (int i = 0; i <= this.n; ++i) {
            double d5;
            double d6;
            if (d3 <= this.times[i] && this.times[i] <= d4) {
                coordinate = this.check(coordinate, this.times[i], false);
            }
            if (i == this.n || !((d6 = Math.max(d3, this.times[i])) < (d5 = Math.min(d4, this.times[i + 1])))) continue;
            coordinate = this.check(coordinate, d6, false);
            coordinate = this.check(coordinate, d5, false);
        }
        return coordinate;
    }
}

