/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public abstract class Curve {
    public static final int splineCurve = 1;
    public static final int lineCurve = 2;
    protected int numpoints;
    protected Coordinate[] positions;
    protected double[] times;
    protected Coordinate start_velocity;
    protected Coordinate end_velocity;

    public abstract void initCurve(String var1) throws JuggleExceptionUser;

    public void setCurve(Coordinate[] coordinateArray, double[] dArray, Coordinate coordinate, Coordinate coordinate2) throws JuggleExceptionInternal {
        this.positions = coordinateArray;
        this.times = dArray;
        this.start_velocity = coordinate;
        this.end_velocity = coordinate2;
        this.numpoints = coordinateArray.length;
        if (this.numpoints != dArray.length) {
            throw new JuggleExceptionInternal("Path error 1");
        }
    }

    public void setCurve(Coordinate[] coordinateArray, double[] dArray) throws JuggleExceptionInternal {
        this.setCurve(coordinateArray, dArray, null, null);
    }

    public abstract void calcCurve() throws JuggleExceptionInternal;

    public double getStartTime() {
        return this.times[0];
    }

    public double getEndTime() {
        return this.times[this.numpoints - 1];
    }

    public double getDuration() {
        return this.times[this.numpoints - 1] - this.times[0];
    }

    public void translateTime(double d) {
        int n = 0;
        while (n < this.numpoints) {
            int n2 = n++;
            this.times[n2] = this.times[n2] + d;
        }
    }

    public abstract void getCoordinate(double var1, Coordinate var3);

    public Coordinate getMax() {
        return this.getMax2(this.times[0], this.times[this.numpoints - 1]);
    }

    public Coordinate getMin() {
        return this.getMin2(this.times[0], this.times[this.numpoints - 1]);
    }

    public Coordinate getMax(double d, double d2) {
        if (d2 < this.getStartTime() || d > this.getEndTime()) {
            return null;
        }
        return this.getMax2(d, d2);
    }

    public Coordinate getMin(double d, double d2) {
        if (d2 < this.getStartTime() || d > this.getEndTime()) {
            return null;
        }
        return this.getMin2(d, d2);
    }

    protected abstract Coordinate getMax2(double var1, double var3);

    protected abstract Coordinate getMin2(double var1, double var3);

    protected Coordinate check(Coordinate coordinate, double d, boolean bl) {
        Coordinate coordinate2 = new Coordinate();
        this.getCoordinate(d, coordinate2);
        coordinate = bl ? Coordinate.max(coordinate, coordinate2) : Coordinate.min(coordinate, coordinate2);
        return coordinate;
    }
}

