/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.AnimationPrefsDialog;
import jugglinglab.core.PlatformSpecific;
import jugglinglab.jml.JMLPattern;
import jugglinglab.optimizer.Optimizer;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.EditView;
import jugglinglab.view.JMLView;
import jugglinglab.view.SelectionView;
import jugglinglab.view.SimpleView;
import jugglinglab.view.View;

public class PatternWindow
extends JFrame
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected View view;
    protected JMenu filemenu;
    protected JMenu viewmenu;
    protected boolean exit_on_close = false;
    protected static final String[] fileItems = new String[]{"Close", null, "Save JML As...", "Save Animated GIF As...", null, "Duplicate", "Optimize"};
    protected static final String[] fileCommands = new String[]{"close", null, "saveas", "savegifanim", null, "duplicate", "optimize"};
    protected static final char[] fileShortcuts = new char[]{'W', ' ', 'S', ' ', ' ', 'D', 'J'};
    protected static final String[] viewItems = new String[]{"Simple", "Visual Editor", "Selection Editor", "JML Editor", null, "Restart", "Animation Preferences..."};
    protected static final String[] viewCommands = new String[]{"simple", "edit", "selection", "jml", null, "restart", "prefs"};
    protected static final char[] viewShortcuts = new char[]{'1', '2', '3', '4', ' ', ' ', 'P'};
    protected static final int FILE_NONE = 0;
    protected static final int FILE_CLOSE = 1;
    protected static final int FILE_SAVE = 2;
    protected static final int FILE_GIFSAVE = 3;
    protected static final int FILE_DUPLICATE = 4;
    protected static final int FILE_OPTIMIZE = 5;
    protected static final int VIEW_RESTART = 6;
    protected static final int VIEW_ANIMPREFS = 7;

    public PatternWindow(String string, JMLPattern jMLPattern, AnimationPrefs animationPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        super(string);
        JMenuBar jMenuBar = new JMenuBar();
        this.filemenu = this.createFileMenu();
        jMenuBar.add(this.filemenu);
        this.viewmenu = this.createViewMenu();
        jMenuBar.add(this.viewmenu);
        this.setJMenuBar(jMenuBar);
        if (animationPrefs != null && animationPrefs.view != 0) {
            this.setViewMode(animationPrefs.view);
            this.viewmenu.getItem(animationPrefs.view - 1).setSelected(true);
        } else if (jMLPattern.getNumberOfJugglers() > 1) {
            this.setViewMode(1);
            this.viewmenu.getItem(0).setSelected(true);
        } else {
            this.setViewMode(2);
            this.viewmenu.getItem(1).setSelected(true);
        }
        this.view.setDoubleBuffered(true);
        if (animationPrefs != null) {
            this.view.setAnimationPanelPreferredSize(new Dimension(animationPrefs.width, animationPrefs.height));
        }
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.white);
        Locale locale = JLLocale.getLocale();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        this.pack();
        this.view.restartView(jMLPattern, animationPrefs);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (PatternWindow.this.exit_on_close) {
                    System.exit(0);
                }
            }
        });
    }

    public void setExitOnClose(boolean bl) {
        this.exit_on_close = bl;
    }

    protected JMenu createFileMenu() {
        JMenu jMenu = new JMenu(guistrings.getString("File"));
        for (int i = 0; i < fileItems.length; ++i) {
            if (fileItems[i] == null) {
                jMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(guistrings.getString(fileItems[i].replace(' ', '_')));
            if (fileShortcuts[i] != ' ') {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            jMenuItem.setActionCommand(fileCommands[i]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            if (!fileCommands[i].equals("optimize") || Optimizer.optimizerAvailable()) continue;
            jMenuItem.setEnabled(false);
        }
        return jMenu;
    }

    protected JMenu createViewMenu() {
        JMenu jMenu = new JMenu(guistrings.getString("View"));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = true;
        for (int i = 0; i < viewItems.length; ++i) {
            JMenuItem jMenuItem;
            if (viewItems[i] == null) {
                jMenu.addSeparator();
                bl = false;
                continue;
            }
            if (bl) {
                jMenuItem = new JRadioButtonMenuItem(guistrings.getString(viewItems[i].replace(' ', '_')));
                if (viewShortcuts[i] != ' ') {
                    jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)viewShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                }
                jMenuItem.setActionCommand(viewCommands[i]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                buttonGroup.add(jMenuItem);
                continue;
            }
            jMenuItem = new JMenuItem(guistrings.getString(viewItems[i].replace(' ', '_')));
            if (viewShortcuts[i] != ' ') {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)viewShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            jMenuItem.setActionCommand(viewCommands[i]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("close")) {
                this.doMenuCommand(1);
            } else if (string.equals("saveas")) {
                this.doMenuCommand(2);
            } else if (string.equals("savegifanim")) {
                this.doMenuCommand(3);
            } else if (string.equals("duplicate")) {
                this.doMenuCommand(4);
            } else if (string.equals("optimize")) {
                this.doMenuCommand(5);
            } else if (string.equals("restart")) {
                this.doMenuCommand(6);
            } else if (string.equals("prefs")) {
                this.doMenuCommand(7);
            } else if (string.equals("simple")) {
                if (this.getViewMode() != 1) {
                    this.setViewMode(1);
                }
            } else if (string.equals("edit")) {
                if (this.getViewMode() != 2) {
                    this.setViewMode(2);
                }
            } else if (string.equals("selection")) {
                if (this.getViewMode() != 3) {
                    this.setViewMode(3);
                }
            } else if (string.equals("jml") && this.getViewMode() != 4) {
                this.setViewMode(4);
            }
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            new ErrorDialog(this, juggleExceptionUser.getMessage());
        }
        catch (Exception exception) {
            ErrorDialog.handleFatalException(exception);
        }
    }

    protected void doMenuCommand(int n) throws JuggleExceptionInternal {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.dispose();
                break;
            }
            case 2: {
                if (this.view != null && this.view.getPattern().isValid()) {
                    try {
                        File file;
                        int n2 = PlatformSpecific.getPlatformSpecific().showSaveDialog(this);
                        if (n2 != 0 || (file = PlatformSpecific.getPlatformSpecific().getSelectedFile()) == null) break;
                        FileWriter fileWriter = new FileWriter(file);
                        this.view.getPattern().writeJML(fileWriter, true);
                        fileWriter.close();
                        break;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new JuggleExceptionInternal("FileNotFound: " + fileNotFoundException.getMessage());
                    }
                    catch (IOException iOException) {
                        throw new JuggleExceptionInternal("IOException: " + iOException.getMessage());
                    }
                }
                new ErrorDialog(this, "Could not save: pattern is not valid");
                break;
            }
            case 3: {
                if (this.view == null) break;
                this.view.writeGIF();
                break;
            }
            case 4: {
                try {
                    new PatternWindow(this.getTitle(), (JMLPattern)this.view.getPattern().clone(), new AnimationPrefs(this.view.getAnimationPrefs()));
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                }
                break;
            }
            case 5: {
                try {
                    if (this.view == null) break;
                    JMLPattern jMLPattern = Optimizer.optimize(this.view.getPattern());
                    AnimationPrefs animationPrefs = this.view.getAnimationPrefs();
                    this.view.restartView(jMLPattern, animationPrefs);
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                }
                break;
            }
            case 6: {
                try {
                    if (this.view == null) break;
                    this.view.restartView();
                    break;
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                    break;
                }
                catch (JuggleException juggleException) {
                    throw new JuggleExceptionInternal(juggleException.getMessage());
                }
            }
            case 7: {
                Object object;
                AnimationPrefsDialog animationPrefsDialog = new AnimationPrefsDialog(this);
                AnimationPrefs animationPrefs = null;
                if (this.view != null) {
                    animationPrefs = this.view.getAnimationPrefs();
                    object = this.view.getAnimationPanelSize();
                    animationPrefs.width = ((Dimension)object).width;
                    animationPrefs.height = ((Dimension)object).height;
                } else {
                    animationPrefs = new AnimationPrefs();
                }
                object = animationPrefsDialog.getPrefs(animationPrefs);
                if (((AnimationPrefs)object).width != animationPrefs.width || ((AnimationPrefs)object).height != animationPrefs.height) {
                    this.view.setAnimationPanelPreferredSize(new Dimension(((AnimationPrefs)object).width, ((AnimationPrefs)object).height));
                    this.pack();
                }
                if (object == animationPrefs) break;
                try {
                    if (this.view == null) break;
                    this.view.restartView(null, (AnimationPrefs)object);
                    break;
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                }
            }
        }
    }

    protected void setViewMode(int n) throws JuggleExceptionUser, JuggleExceptionInternal {
        View view = null;
        JMLPattern jMLPattern = null;
        AnimationPrefs animationPrefs = null;
        Dimension dimension = null;
        boolean bl = false;
        if (this.view != null) {
            jMLPattern = this.view.getPattern();
            animationPrefs = this.view.getAnimationPrefs();
            dimension = this.view.getAnimationPanelSize();
            bl = this.view.getPaused();
        } else {
            AnimationPrefs animationPrefs2 = new AnimationPrefs();
            dimension = new Dimension(animationPrefs2.width, animationPrefs2.height);
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                view = new SimpleView(dimension);
                break;
            }
            case 2: {
                view = new EditView(dimension);
                break;
            }
            case 3: {
                view = new SelectionView(dimension);
                break;
            }
            case 4: {
                view = new JMLView(dimension);
            }
        }
        if (view == null) {
            throw new JuggleExceptionInternal("setViewMode: problem creating view");
        }
        view.setParent(this);
        view.setPaused(bl);
        view.setOpaque(true);
        this.setContentPane(view);
        if (this.view != null) {
            this.view.disposeView();
            this.view = view;
            this.pack();
            this.view.restartView(jMLPattern, animationPrefs);
        } else {
            this.view = view;
        }
    }

    protected int getViewMode() {
        if (this.view == null) {
            return 0;
        }
        if (this.view instanceof SimpleView) {
            return 1;
        }
        if (this.view instanceof EditView) {
            return 2;
        }
        if (this.view instanceof SelectionView) {
            return 3;
        }
        if (this.view instanceof JMLView) {
            return 4;
        }
        return 0;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.view != null) {
            this.view.disposeView();
            this.view = null;
        }
    }
}

