/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import jugglinglab.JugglingLab;
import jugglinglab.core.PatternList;
import jugglinglab.core.PlatformSpecific;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class PatternListWindow
extends JFrame
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    String title = null;
    PatternList pl = null;
    protected JMenuItem[] fileitems = null;
    protected String[] fileItems = new String[]{"Close", null, "Save JML As...", "Save Text As..."};
    protected String[] fileCommands = new String[]{"close", null, "saveas", "savetext"};
    protected char[] fileShortcuts = new char[]{'W', ' ', 'S', 'T'};
    public static final int FILE_NONE = 0;
    public static final int FILE_CLOSE = 1;
    public static final int FILE_SAVE = 2;
    public static final int FILE_SAVETEXT = 3;

    public PatternListWindow(String string) {
        super(string);
        this.title = string;
        this.makeWindow();
        this.pl.setTitle(string);
        this.setDefaultCloseOperation(2);
    }

    public PatternListWindow(String string, Thread thread) {
        this(string);
        final Thread thread2 = thread;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                try {
                    if (thread2 != null) {
                        thread2.interrupt();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public PatternListWindow(JMLNode jMLNode) throws JuggleExceptionUser {
        this.makeWindow();
        this.pl.readJML(jMLNode);
        this.title = this.pl.getTitle() != null ? this.pl.getTitle() : guistrings.getString("Patterns");
        this.setTitle(this.title);
        this.setDefaultCloseOperation(2);
    }

    protected void makeWindow() {
        this.pl = new PatternList(null);
        this.pl.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.setContentPane(this.pl);
        this.setSize(300, 450);
        this.createMenuBar();
        Locale locale = JLLocale.getLocale();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        this.setLocation(150, 200);
        this.setVisible(true);
    }

    public PatternList getPatternList() {
        return this.pl;
    }

    protected void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(guistrings.getString("File"));
        this.fileitems = new JMenuItem[this.fileItems.length];
        for (int i = 0; i < this.fileItems.length; ++i) {
            if (this.fileItems[i] == null) {
                jMenu.addSeparator();
                continue;
            }
            this.fileitems[i] = new JMenuItem(guistrings.getString(this.fileItems[i].replace(' ', '_')));
            if (this.fileShortcuts[i] != ' ') {
                this.fileitems[i].setAccelerator(KeyStroke.getKeyStroke((int)this.fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            this.fileitems[i].setActionCommand(this.fileCommands[i]);
            this.fileitems[i].addActionListener(this);
            jMenu.add(this.fileitems[i]);
        }
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("close")) {
                this.doFileMenuCommand(1);
            } else if (string.equals("saveas")) {
                this.doFileMenuCommand(2);
            } else if (string.equals("savetext")) {
                this.doFileMenuCommand(3);
            }
        }
        catch (Exception exception) {
            ErrorDialog.handleFatalException(exception);
        }
    }

    public void doFileMenuCommand(int n) throws JuggleExceptionInternal {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.dispose();
                break;
            }
            case 2: {
                try {
                    int n2 = PlatformSpecific.getPlatformSpecific().showSaveDialog(this);
                    if (n2 != 0 || PlatformSpecific.getPlatformSpecific().getSelectedFile() == null) break;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    FileWriter fileWriter = new FileWriter(PlatformSpecific.getPlatformSpecific().getSelectedFile());
                    this.pl.writeJML(fileWriter);
                    fileWriter.close();
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new JuggleExceptionInternal("File not found on save: " + fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    throw new JuggleExceptionInternal("IOException on save: " + iOException.getMessage());
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            case 3: {
                try {
                    int n3 = PlatformSpecific.getPlatformSpecific().showSaveDialog(this);
                    if (n3 != 0 || PlatformSpecific.getPlatformSpecific().getSelectedFile() == null) break;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    FileWriter fileWriter = new FileWriter(PlatformSpecific.getPlatformSpecific().getSelectedFile());
                    this.pl.writeText(fileWriter);
                    fileWriter.close();
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new JuggleExceptionInternal("File not found on save: " + fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    throw new JuggleExceptionInternal("IOException on save: " + iOException.getMessage());
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    public void addPattern(String string, String string2, String string3, String string4, JMLNode jMLNode) {
        this.pl.addPattern(string, string2, string3, string4, jMLNode);
    }
}

