/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLDefs;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.Pattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.view.View;

public class PatternList
extends JPanel {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    static final Font font_nopattern = new Font("SanSerif", 3, 14);
    static final Font font_pattern = new Font("Monospaced", 0, 14);
    View animtarget;
    String title;
    JList<PatternRecord> list;
    DefaultListModel<PatternRecord> model;
    String loadingversion = null;

    public PatternList() {
        this.makePanel();
        this.setOpaque(false);
    }

    public PatternList(View view) {
        this.makePanel();
        this.setOpaque(false);
        this.setTargetView(view);
    }

    protected void makePanel() {
        this.model = new DefaultListModel();
        this.list = new JList<PatternRecord>(this.model);
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.setCellRenderer(new PatternCellRenderer());
        this.list.setDragEnabled(true);
        this.list.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 1;
            }

            @Override
            public Transferable createTransferable(JComponent jComponent) {
                PatternRecord patternRecord = PatternList.this.model.get(PatternList.this.list.getSelectedIndex());
                String string = patternRecord.anim == null || patternRecord.anim.equals("") ? patternRecord.display : patternRecord.anim;
                return new StringSelection(string);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PatternWindow patternWindow = null;
                try {
                    Object object;
                    PatternRecord patternRecord = PatternList.this.model.get(PatternList.this.list.getSelectedIndex());
                    JMLPattern jMLPattern = null;
                    if (patternRecord.notation != null && patternRecord.notation.equalsIgnoreCase("JML") && patternRecord.pattern != null) {
                        jMLPattern = new JMLPattern(patternRecord.pattern, PatternList.this.loadingversion);
                    } else if (patternRecord.notation != null && patternRecord.anim != null) {
                        object = Pattern.newPattern(patternRecord.notation);
                        jMLPattern = ((Pattern)object).fromString(patternRecord.anim).asJMLPattern();
                    } else {
                        return;
                    }
                    if (jMLPattern != null) {
                        jMLPattern.setTitle(patternRecord.display);
                        object = new AnimationPrefs();
                        if (patternRecord.animprefs != null) {
                            ParameterList parameterList = new ParameterList(patternRecord.animprefs);
                            ((AnimationPrefs)object).fromParameters(parameterList);
                            parameterList.errorIfParametersLeft();
                        }
                        if (PatternList.this.animtarget != null) {
                            PatternList.this.animtarget.restartView(jMLPattern, (AnimationPrefs)object);
                        } else {
                            patternWindow = new PatternWindow(jMLPattern.getTitle(), jMLPattern, (AnimationPrefs)object);
                        }
                    }
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    if (patternWindow != null) {
                        patternWindow.dispose();
                    }
                    new ErrorDialog(PatternList.this, juggleExceptionUser.getMessage());
                }
                catch (Exception exception) {
                    if (patternWindow != null) {
                        patternWindow.dispose();
                    }
                    ErrorDialog.handleFatalException(exception);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public void setTargetView(View view) {
        this.animtarget = view;
    }

    public void addPattern(String string, String string2, String string3, String string4, JMLNode jMLNode) {
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string4 != null) {
            string4 = string4.trim();
        }
        PatternRecord patternRecord = new PatternRecord(string, string2, string3, string4, jMLNode);
        this.model.addElement(patternRecord);
    }

    public void clearList() {
        this.model.clear();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void readJML(JMLNode jMLNode) throws JuggleExceptionUser {
        JMLNode jMLNode2;
        if (!jMLNode.getNodeType().equalsIgnoreCase("jml")) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_missing_JML_tag"));
        }
        this.loadingversion = jMLNode.getAttributes().getAttribute("version");
        if (this.loadingversion == null) {
            this.loadingversion = "1.0";
        }
        if (!(jMLNode2 = jMLNode.getChildNode(0)).getNodeType().equalsIgnoreCase("patternlist")) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_missing_patternlist_tag"));
        }
        int n = 0;
        for (int i = 0; i < jMLNode2.getNumberOfChildren(); ++i) {
            JMLNode jMLNode3 = jMLNode2.getChildNode(i);
            if (jMLNode3.getNodeType().equalsIgnoreCase("title")) {
                this.title = jMLNode3.getNodeValue().trim();
                continue;
            }
            if (jMLNode3.getNodeType().equalsIgnoreCase("line")) {
                ++n;
                JMLAttributes jMLAttributes = jMLNode3.getAttributes();
                String string = jMLAttributes.getAttribute("display");
                if (string == null || string.equals("")) {
                    string = " ";
                }
                String string2 = jMLAttributes.getAttribute("animprefs");
                String string3 = jMLAttributes.getAttribute("notation");
                String string4 = null;
                Object[] objectArray = null;
                if (string3 != null) {
                    if (string3.equalsIgnoreCase("JML")) {
                        Object[] objectArray2;
                        for (int j = 0; j < jMLNode3.getNumberOfChildren(); ++j) {
                            objectArray2 = jMLNode3.getChildNode(j);
                            if (!objectArray2.getNodeType().equalsIgnoreCase("pattern")) continue;
                            objectArray = objectArray2;
                            break;
                        }
                        if (objectArray == null) {
                            String string5 = errorstrings.getString("Error_missing_pattern");
                            objectArray2 = new Object[]{n};
                            throw new JuggleExceptionUser(MessageFormat.format(string5, objectArray2));
                        }
                    } else {
                        string4 = jMLNode3.getNodeValue().trim();
                    }
                }
                this.addPattern(string, string2, string3, string4, (JMLNode)objectArray);
                continue;
            }
            throw new JuggleExceptionUser(errorstrings.getString("Error_illegal_tag"));
        }
    }

    public void writeJML(Writer writer) throws IOException {
        int n;
        PrintWriter printWriter = new PrintWriter(writer);
        for (int i = 0; i < JMLDefs.jmlprefix.length; ++i) {
            printWriter.println(JMLDefs.jmlprefix[i]);
        }
        String string = this.loadingversion;
        if (string == null) {
            string = "1.2";
        }
        printWriter.println("<jml version=\"" + string + "\">");
        printWriter.println("<patternlist>");
        printWriter.println("<title>" + JMLNode.xmlescape(this.title) + "</title>");
        for (n = 0; n < this.model.size(); ++n) {
            PatternRecord patternRecord = this.model.get(n);
            String string2 = "<line display=\"" + JMLNode.xmlescape(patternRecord.display) + "\"";
            if (patternRecord.notation != null) {
                string2 = string2 + " notation=\"" + JMLNode.xmlescape(patternRecord.notation.toLowerCase()) + "\"";
            }
            if (patternRecord.animprefs != null) {
                string2 = string2 + " animprefs=\"" + JMLNode.xmlescape(patternRecord.animprefs) + "\"";
            }
            string2 = string2 + ">";
            printWriter.println(string2);
            if (patternRecord.notation != null && patternRecord.notation.equalsIgnoreCase("JML") && patternRecord.pattern != null) {
                patternRecord.pattern.writeNode(printWriter, 0);
            } else if (patternRecord.anim != null) {
                printWriter.println(JMLNode.xmlescape(patternRecord.anim));
            }
            printWriter.println("</line>");
        }
        printWriter.println("</patternlist>");
        printWriter.println("</jml>");
        for (n = 0; n < JMLDefs.jmlsuffix.length; ++n) {
            printWriter.println(JMLDefs.jmlsuffix[n]);
        }
        printWriter.flush();
    }

    public void writeText(Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        for (int i = 0; i < this.model.size(); ++i) {
            PatternRecord patternRecord = this.model.get(i);
            printWriter.println(patternRecord.display);
        }
        printWriter.flush();
    }

    class PatternCellRenderer
    extends JLabel
    implements ListCellRenderer<PatternRecord> {
        PatternCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PatternRecord> jList, PatternRecord patternRecord, int n, boolean bl, boolean bl2) {
            PatternRecord patternRecord2 = patternRecord;
            this.setFont(patternRecord2.anim == null && patternRecord2.pattern == null ? font_nopattern : font_pattern);
            this.setText(patternRecord2.display);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setOpaque(true);
            return this;
        }
    }

    class PatternRecord {
        public String display;
        public String animprefs;
        public String notation;
        public String anim;
        public JMLNode pattern;

        public PatternRecord(String string, String string2, String string3, String string4, JMLNode jMLNode) {
            this.display = string;
            this.animprefs = string2;
            this.notation = string3;
            this.anim = string4;
            this.pattern = jMLNode;
        }
    }
}

