/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.JPanel;
import jugglinglab.core.LadderEventItem;
import jugglinglab.core.LadderItem;
import jugglinglab.core.LadderPathItem;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;

public class LadderDiagram
extends JPanel {
    protected static final Color background = Color.white;
    protected static final int border_top = 25;
    protected static final double border_sides = 0.15;
    protected static final int transition_radius = 5;
    protected static final double selfthrow_width = 0.25;
    protected static final int path_slop = 5;
    protected static final int cacheframes = 5;
    protected static final double passing_border_sides = 0.2;
    protected JMLPattern pat = null;
    protected double sim_time = 0.0;
    protected int width;
    protected int height;
    protected int right_x;
    protected int left_x;
    protected int passing_first_x;
    protected int passing_offset_x;
    protected int tracker_y = 25;
    private boolean has_switch_symmetry;
    private boolean has_switchdelay_symmetry;
    protected ArrayList<LadderEventItem> laddereventitems;
    protected ArrayList<LadderPathItem> ladderpathitems;
    protected Image laddercache;
    protected boolean laddercachedirty;
    protected int cacheframesleft;
    protected boolean anim_paused;

    public LadderDiagram(JMLPattern jMLPattern) {
        this.setBackground(background);
        this.setOpaque(false);
        this.pat = jMLPattern;
        this.createView();
    }

    protected LadderEventItem getSelectedLadderEvent(int n, int n2) {
        for (int i = 0; i < this.laddereventitems.size(); ++i) {
            LadderEventItem ladderEventItem = this.laddereventitems.get(i);
            if (n < ladderEventItem.xlow || n > ladderEventItem.xhigh || n2 < ladderEventItem.ylow || n2 > ladderEventItem.yhigh) continue;
            return ladderEventItem;
        }
        return null;
    }

    protected LadderPathItem getSelectedLadderPath(int n, int n2, int n3) {
        LadderPathItem ladderPathItem = null;
        double d = 0.0;
        if (n2 < 25 - n3 || n2 > this.height - 25 + n3) {
            return null;
        }
        for (int i = 0; i < this.ladderpathitems.size(); ++i) {
            double d2;
            LadderPathItem ladderPathItem2 = this.ladderpathitems.get(i);
            if (ladderPathItem2.type == 3) {
                if (n2 < ladderPathItem2.ystart - n3 || n2 > ladderPathItem2.yend + n3) continue;
                d2 = (n - ladderPathItem2.xcenter) * (n - ladderPathItem2.xcenter) + (n2 - ladderPathItem2.ycenter) * (n2 - ladderPathItem2.ycenter);
                d2 = Math.abs(Math.sqrt(d2) - (double)ladderPathItem2.radius);
            } else {
                int n4;
                int n5 = ladderPathItem2.xstart < ladderPathItem2.xend ? ladderPathItem2.xstart : ladderPathItem2.xend;
                int n6 = n4 = ladderPathItem2.xstart < ladderPathItem2.xend ? ladderPathItem2.xend : ladderPathItem2.xstart;
                if (n < n5 - n3 || n > n4 + n3 || n2 < ladderPathItem2.ystart - n3 || n2 > ladderPathItem2.yend + n3) continue;
                d2 = (ladderPathItem2.xend - ladderPathItem2.xstart) * (n2 - ladderPathItem2.ystart) - (n - ladderPathItem2.xstart) * (ladderPathItem2.yend - ladderPathItem2.ystart);
                d2 = Math.abs(d2) / Math.sqrt((ladderPathItem2.xend - ladderPathItem2.xstart) * (ladderPathItem2.xend - ladderPathItem2.xstart) + (ladderPathItem2.yend - ladderPathItem2.ystart) * (ladderPathItem2.yend - ladderPathItem2.ystart));
            }
            if ((int)d2 >= n3 || ladderPathItem != null && !(d2 < d)) continue;
            ladderPathItem = ladderPathItem2;
            d = d2;
        }
        return ladderPathItem;
    }

    public void setPathColor(int n, Color color) {
        for (int i = 0; i < this.ladderpathitems.size(); ++i) {
            LadderPathItem ladderPathItem = this.ladderpathitems.get(i);
            if (ladderPathItem.pathnum != n) continue;
            ladderPathItem.color = color;
        }
    }

    public void setTime(double d) {
        if (this.sim_time == d) {
            return;
        }
        this.sim_time = d;
        this.setTrackerPosition();
        this.repaint();
    }

    protected void setTrackerPosition() {
        double d = this.pat.getLoopStartTime();
        double d2 = this.pat.getLoopEndTime();
        this.tracker_y = (int)(0.5 + (double)(this.height - 50) * (this.sim_time - d) / (d2 - d)) + 25;
    }

    protected void createView() {
        Object object;
        JMLEvent jMLEvent;
        this.has_switchdelay_symmetry = false;
        this.has_switch_symmetry = false;
        block4: for (int i = 0; i < this.pat.getNumberOfSymmetries(); ++i) {
            JMLSymmetry jMLSymmetry = this.pat.getSymmetry(i);
            switch (jMLSymmetry.getType()) {
                case 2: {
                    this.has_switch_symmetry = true;
                    continue block4;
                }
                case 3: {
                    this.has_switchdelay_symmetry = true;
                }
            }
        }
        this.laddereventitems = new ArrayList();
        double d = this.pat.getLoopStartTime();
        double d2 = this.pat.getLoopEndTime();
        JMLEvent jMLEvent2 = jMLEvent = this.pat.getEventList();
        while (jMLEvent2.getT() < d) {
            jMLEvent2 = jMLEvent2.getNext();
        }
        while (jMLEvent2.getT() < d2) {
            LadderEventItem ladderEventItem = new LadderEventItem();
            ladderEventItem.type = 1;
            ladderEventItem.eventitem = ladderEventItem;
            ladderEventItem.event = jMLEvent2;
            this.laddereventitems.add(ladderEventItem);
            int n = 0;
            while (n < jMLEvent2.getNumberOfTransitions()) {
                object = new LadderEventItem();
                ((LadderEventItem)object).type = 2;
                ((LadderEventItem)object).eventitem = ladderEventItem;
                ((LadderEventItem)object).event = jMLEvent2;
                ((LadderEventItem)object).transnum = n++;
                this.laddereventitems.add((LadderEventItem)object);
            }
            jMLEvent2 = jMLEvent2.getNext();
        }
        this.ladderpathitems = new ArrayList();
        if (this.pat.getNumberOfJugglers() == 1) {
            jMLEvent2 = jMLEvent;
            while (jMLEvent2.getT() <= d2) {
                for (int i = 0; i < jMLEvent2.getNumberOfTransitions(); ++i) {
                    JMLTransition jMLTransition = jMLEvent2.getTransition(i);
                    object = jMLTransition.getOutgoingPathLink();
                    if (object == null) continue;
                    LadderPathItem ladderPathItem = new LadderPathItem();
                    ladderPathItem.transnum_start = i;
                    ladderPathItem.startevent = ((PathLink)object).getStartEvent();
                    ladderPathItem.endevent = ((PathLink)object).getEndEvent();
                    ladderPathItem.type = ((PathLink)object).isInHand() ? 5 : (ladderPathItem.startevent.getHand() == ladderPathItem.endevent.getHand() ? 3 : 4);
                    ladderPathItem.pathnum = ((PathLink)object).getPathNum();
                    ladderPathItem.color = Color.black;
                    this.ladderpathitems.add(ladderPathItem);
                }
                jMLEvent2 = jMLEvent2.getNext();
            }
        }
        this.updateView();
    }

    protected void updateView() {
        LadderItem ladderItem;
        int n;
        Dimension dimension = this.getSize();
        this.width = dimension.width;
        this.height = dimension.height;
        this.left_x = (int)((double)this.width / 2.0 * 0.15);
        this.right_x = this.width - this.left_x;
        if (this.pat.getNumberOfJugglers() > 1) {
            this.passing_first_x = (int)((double)this.width / 2.0 * 0.2);
            this.passing_offset_x = (int)((double)(this.width - 2 * this.passing_first_x) / (double)(this.pat.getNumberOfJugglers() - 1));
        }
        this.laddercachedirty = true;
        this.laddercache = null;
        this.cacheframesleft = 5;
        double d = this.pat.getLoopStartTime();
        double d2 = this.pat.getLoopEndTime();
        for (n = 0; n < this.laddereventitems.size(); ++n) {
            ladderItem = this.laddereventitems.get(n);
            JMLEvent jMLEvent = ladderItem.event;
            int n2 = (jMLEvent.getHand() == 1 ? this.left_x : this.right_x) - 5;
            int n3 = (int)(0.5 + (double)(this.height - 50) * (jMLEvent.getT() - d) / (d2 - d)) + 25 - 5;
            if (ladderItem.type == 1) {
                ladderItem.xlow = n2;
                ladderItem.xhigh = n2 + 10;
                ladderItem.ylow = n3;
                ladderItem.yhigh = n3 + 10;
                continue;
            }
            n2 = jMLEvent.getHand() == 1 ? (n2 += 10 * (ladderItem.transnum + 1)) : (n2 -= 10 * (ladderItem.transnum + 1));
            ladderItem.xlow = n2;
            ladderItem.xhigh = n2 + 10;
            ladderItem.ylow = n3;
            ladderItem.yhigh = n3 + 10;
        }
        for (n = 0; n < this.ladderpathitems.size(); ++n) {
            ladderItem = this.ladderpathitems.get(n);
            ((LadderPathItem)ladderItem).xstart = ((LadderPathItem)ladderItem).startevent.getHand() == 1 ? this.left_x + (((LadderPathItem)ladderItem).transnum_start + 1) * 2 * 5 : this.right_x - (((LadderPathItem)ladderItem).transnum_start + 1) * 2 * 5;
            ((LadderPathItem)ladderItem).ystart = (int)(0.5 + (double)(this.height - 50) * (((LadderPathItem)ladderItem).startevent.getT() - d) / (d2 - d)) + 25;
            ((LadderPathItem)ladderItem).yend = (int)(0.5 + (double)(this.height - 50) * (((LadderPathItem)ladderItem).endevent.getT() - d) / (d2 - d)) + 25;
            int n4 = 0;
            for (int i = 0; i < ((LadderPathItem)ladderItem).endevent.getNumberOfTransitions(); ++i) {
                JMLTransition jMLTransition = ((LadderPathItem)ladderItem).endevent.getTransition(i);
                if (jMLTransition.getPath() != ((LadderPathItem)ladderItem).pathnum) continue;
                n4 = i;
                break;
            }
            int n5 = ((LadderPathItem)ladderItem).xend = ((LadderPathItem)ladderItem).endevent.getHand() == 1 ? this.left_x + (n4 + 1) * 2 * 5 : this.right_x - (n4 + 1) * 2 * 5;
            if (((LadderPathItem)ladderItem).type != 3) continue;
            double d3 = 0.5 * Math.sqrt((double)((((LadderPathItem)ladderItem).xstart - ((LadderPathItem)ladderItem).xend) * (((LadderPathItem)ladderItem).xstart - ((LadderPathItem)ladderItem).xend)) + (double)((((LadderPathItem)ladderItem).ystart - ((LadderPathItem)ladderItem).yend) * (((LadderPathItem)ladderItem).ystart - ((LadderPathItem)ladderItem).yend)));
            double d4 = 0.5 * (double)(((LadderPathItem)ladderItem).xstart + ((LadderPathItem)ladderItem).xend);
            double d5 = 0.5 * (double)(((LadderPathItem)ladderItem).ystart + ((LadderPathItem)ladderItem).yend);
            double d6 = 0.25 * (double)this.width;
            double d7 = 0.5 * (d3 * d3 / d6 - d6);
            if (d7 < 0.5 * d6) {
                d7 = 0.5 * d6;
            }
            double d8 = ((LadderPathItem)ladderItem).endevent.getHand() == 1 ? -1.0 : 1.0;
            double d9 = d4 + d8 * d7 * (d5 - (double)((LadderPathItem)ladderItem).ystart) / d3;
            double d10 = d5 + d8 * d7 * ((double)((LadderPathItem)ladderItem).xstart - d4) / d3;
            double d11 = Math.sqrt(((double)((LadderPathItem)ladderItem).xstart - d9) * ((double)((LadderPathItem)ladderItem).xstart - d9) + ((double)((LadderPathItem)ladderItem).ystart - d10) * ((double)((LadderPathItem)ladderItem).ystart - d10));
            ((LadderPathItem)ladderItem).xcenter = (int)(0.5 + d9);
            ((LadderPathItem)ladderItem).ycenter = (int)(0.5 + d10);
            ((LadderPathItem)ladderItem).radius = (int)(0.5 + d11);
        }
        this.setTrackerPosition();
    }

    protected void paintBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width != this.width || dimension.height != this.height) {
            this.updateView();
        }
        if (this.laddercachedirty) {
            Graphics graphics2 = graphics;
            if (this.cacheframesleft == 0) {
                this.laddercache = this.createImage(this.width, this.height);
                graphics2 = this.laddercache.getGraphics();
                if (graphics2 instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics2;
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.laddercachedirty = false;
            } else {
                --this.cacheframesleft;
            }
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, this.width, this.height);
            if (this.pat.getNumberOfJugglers() == 1) {
                graphics2.setColor(Color.lightGray);
                graphics2.drawLine(0, 25, this.width, 25);
                graphics2.drawLine(0, this.height - 25, this.width, this.height - 25);
                if (this.has_switch_symmetry) {
                    graphics2.drawLine(this.left_x, this.height - 12, this.right_x, this.height - 12);
                    graphics2.drawLine(this.left_x, this.height - 12, this.left_x + this.left_x, this.height - 18);
                    graphics2.drawLine(this.left_x, this.height - 12, this.left_x + this.left_x, this.height - 6);
                    graphics2.drawLine(this.right_x, this.height - 12, this.right_x - this.left_x, this.height - 18);
                    graphics2.drawLine(this.right_x, this.height - 12, this.right_x - this.left_x, this.height - 6);
                }
                if (this.has_switchdelay_symmetry) {
                    graphics2.drawLine(0, this.height / 2, this.width, this.height / 2);
                }
                graphics2.setColor(Color.black);
                for (int i = -1; i < 2; ++i) {
                    graphics2.drawLine(this.left_x + i, 25, this.left_x + i, this.height - 25);
                    graphics2.drawLine(this.right_x + i, 25, this.right_x + i, this.height - 25);
                }
                Shape shape = graphics2.getClip();
                for (int i = 0; i < this.ladderpathitems.size(); ++i) {
                    LadderPathItem ladderPathItem = this.ladderpathitems.get(i);
                    graphics2.setColor(ladderPathItem.color);
                    graphics2.clipRect(this.left_x, 25, this.right_x - this.left_x, this.height - 50);
                    if (ladderPathItem.type == 4) {
                        graphics2.drawLine(ladderPathItem.xstart, ladderPathItem.ystart, ladderPathItem.xend, ladderPathItem.yend);
                    } else if (ladderPathItem.type == 5) {
                        graphics2.drawLine(ladderPathItem.xstart, ladderPathItem.ystart, ladderPathItem.xend, ladderPathItem.yend);
                    } else if (ladderPathItem.yend >= 25) {
                        graphics2.clipRect(this.left_x, ladderPathItem.ystart, this.right_x - this.left_x, ladderPathItem.yend - ladderPathItem.ystart);
                        graphics2.drawOval(ladderPathItem.xcenter - ladderPathItem.radius, ladderPathItem.ycenter - ladderPathItem.radius, 2 * ladderPathItem.radius, 2 * ladderPathItem.radius);
                    }
                    graphics2.setClip(shape);
                }
            } else {
                graphics2.setColor(Color.black);
                for (int i = 0; i < this.pat.getNumberOfJugglers(); ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int n = this.passing_first_x + i * this.passing_offset_x;
                        graphics2.drawLine(n + j, 25, n + j, this.height - 25);
                    }
                }
            }
        }
        if (!this.laddercachedirty) {
            graphics.drawImage(this.laddercache, 0, 0, this);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.paintBackground(graphics);
        graphics.setColor(Color.black);
        for (int i = 0; i < this.laddereventitems.size(); ++i) {
            LadderEventItem ladderEventItem = this.laddereventitems.get(i);
            if (ladderEventItem.type == 1) {
                graphics.fillOval(ladderEventItem.xlow, ladderEventItem.ylow, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
                continue;
            }
            graphics.setColor(this.getBackground());
            graphics.fillOval(ladderEventItem.xlow, ladderEventItem.ylow, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
            graphics.setColor(Color.black);
            graphics.drawOval(ladderEventItem.xlow, ladderEventItem.ylow, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
        }
        graphics.setColor(Color.red);
        graphics.drawLine(0, this.tracker_y, this.width, this.tracker_y);
    }
}

