/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationEditPanel;
import jugglinglab.core.LadderDiagram;
import jugglinglab.core.LadderEventItem;
import jugglinglab.core.LadderItem;
import jugglinglab.core.LadderPathItem;
import jugglinglab.core.PlatformSpecific;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PropDef;
import jugglinglab.path.Path;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.Permutation;

public class EditLadderDiagram
extends LadderDiagram
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final double min_throw_time = 0.05;
    protected static final double min_hold_time = 0.05;
    protected AnimationEditPanel animator;
    protected JFrame parent;
    private static final int STATE_INACTIVE = 0;
    private static final int STATE_EVENT_SELECTED = 1;
    private static final int STATE_MOVING_EVENT = 2;
    private static final int STATE_MOVING_TRACKER = 3;
    private static final int STATE_POPUP = 4;
    protected int gui_state;
    protected LadderEventItem active_eventitem;
    protected int start_y;
    protected int delta_y;
    protected int delta_y_min;
    protected int delta_y_max;
    protected LadderItem popupitem;
    protected int popup_y;
    protected JPopupMenu popup;
    protected JMenuItem[] popupmenuitems;
    protected ArrayList<JComponent> dialog_controls;
    protected ParameterDescriptor[] dialog_pd;
    private static String[] popupItems = new String[]{"Change title...", "Change overall timing...", "Add event to L hand", "Add event to R hand", null, "Remove event", null, "Define prop...", "Make last in event", "Define throw...", "Change to catch", "Change to softcatch"};
    private static final String[] booleanList = new String[]{"True", "False"};

    public EditLadderDiagram(JMLPattern jMLPattern, JFrame jFrame) {
        super(jMLPattern);
        this.parent = jFrame;
        this.active_eventitem = null;
        this.setupPopup();
        final JMLPattern jMLPattern2 = jMLPattern;
        this.gui_state = 0;
        if (jMLPattern.getNumberOfJugglers() > 1) {
            return;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (EditLadderDiagram.this.animator != null && EditLadderDiagram.this.animator.writingGIF) {
                    return;
                }
                int n = mouseEvent.getY();
                if (n < 25) {
                    n = 25;
                } else if (n > EditLadderDiagram.this.height - 25) {
                    n = EditLadderDiagram.this.height - 25;
                }
                if (mouseEvent.isPopupTrigger()) {
                    EditLadderDiagram.this.gui_state = 4;
                    EditLadderDiagram.this.active_eventitem = EditLadderDiagram.this.getSelectedLadderEvent(mouseEvent.getX(), mouseEvent.getY());
                    EditLadderDiagram.this.popupitem = EditLadderDiagram.this.active_eventitem != null ? EditLadderDiagram.this.active_eventitem : EditLadderDiagram.this.getSelectedLadderPath(mouseEvent.getX(), mouseEvent.getY(), 5);
                    EditLadderDiagram.this.popup_y = mouseEvent.getY();
                    if (EditLadderDiagram.this.animator != null) {
                        double d = (jMLPattern2.getLoopEndTime() - jMLPattern2.getLoopStartTime()) / (double)(EditLadderDiagram.this.height - 50);
                        double d2 = (double)(n - 25) * d;
                        EditLadderDiagram.this.anim_paused = EditLadderDiagram.this.animator.getPaused();
                        EditLadderDiagram.this.animator.setPaused(true);
                        EditLadderDiagram.this.animator.setTime(d2);
                        EditLadderDiagram.this.animator.deactivateEvent();
                        if (EditLadderDiagram.this.active_eventitem != null) {
                            EditLadderDiagram.this.animator.activateEvent(EditLadderDiagram.this.active_eventitem.event);
                        }
                        EditLadderDiagram.this.animator.repaint();
                    }
                    EditLadderDiagram.this.adjustPopup(EditLadderDiagram.this.popupitem);
                    EditLadderDiagram.this.popup.show(EditLadderDiagram.this, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    switch (EditLadderDiagram.this.gui_state) {
                        case 0: 
                        case 1: {
                            EditLadderDiagram.this.active_eventitem = EditLadderDiagram.this.getSelectedLadderEvent(mouseEvent.getX(), mouseEvent.getY());
                            if (EditLadderDiagram.this.active_eventitem == null) {
                                EditLadderDiagram.this.gui_state = 3;
                                EditLadderDiagram.this.tracker_y = n;
                                EditLadderDiagram.this.repaint();
                                if (EditLadderDiagram.this.animator == null) break;
                                double d = (jMLPattern2.getLoopEndTime() - jMLPattern2.getLoopStartTime()) / (double)(EditLadderDiagram.this.height - 50);
                                double d3 = (double)(n - 25) * d;
                                EditLadderDiagram.this.anim_paused = EditLadderDiagram.this.animator.getPaused();
                                EditLadderDiagram.this.animator.setPaused(true);
                                EditLadderDiagram.this.animator.setTime(d3);
                                EditLadderDiagram.this.animator.deactivateEvent();
                                EditLadderDiagram.this.animator.repaint();
                                break;
                            }
                            EditLadderDiagram.this.gui_state = 2;
                            EditLadderDiagram.this.start_y = mouseEvent.getY();
                            EditLadderDiagram.this.findEventLimits(EditLadderDiagram.this.active_eventitem);
                            EditLadderDiagram.this.repaint();
                            if (EditLadderDiagram.this.animator == null) break;
                            EditLadderDiagram.this.animator.activateEvent(EditLadderDiagram.this.active_eventitem.event);
                            EditLadderDiagram.this.animator.repaint();
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            int n2 = EditLadderDiagram.this.gui_state = EditLadderDiagram.this.active_eventitem == null ? 0 : 1;
                            if (EditLadderDiagram.this.animator == null) break;
                            EditLadderDiagram.this.animator.setPaused(EditLadderDiagram.this.anim_paused);
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (EditLadderDiagram.this.animator != null && EditLadderDiagram.this.animator.writingGIF) {
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    switch (EditLadderDiagram.this.gui_state) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            if (EditLadderDiagram.this.gui_state != 3 && EditLadderDiagram.this.animator != null) {
                                int n = mouseEvent.getY();
                                if (n < 25) {
                                    n = 25;
                                } else if (n > EditLadderDiagram.this.height - 25) {
                                    n = EditLadderDiagram.this.height - 25;
                                }
                                double d = (jMLPattern2.getLoopEndTime() - jMLPattern2.getLoopStartTime()) / (double)(EditLadderDiagram.this.height - 50);
                                double d2 = (double)(n - 25) * d;
                                EditLadderDiagram.this.anim_paused = EditLadderDiagram.this.animator.getPaused();
                                EditLadderDiagram.this.animator.setPaused(true);
                                EditLadderDiagram.this.animator.setTime(d2);
                                EditLadderDiagram.this.animator.deactivateEvent();
                                if (EditLadderDiagram.this.active_eventitem != null) {
                                    EditLadderDiagram.this.animator.activateEvent(EditLadderDiagram.this.active_eventitem.event);
                                }
                                EditLadderDiagram.this.animator.repaint();
                            }
                            EditLadderDiagram.this.gui_state = 4;
                            if (EditLadderDiagram.this.delta_y != 0) {
                                EditLadderDiagram.this.delta_y = 0;
                                EditLadderDiagram.this.repaint();
                            }
                            EditLadderDiagram.this.popup_y = mouseEvent.getY();
                            EditLadderDiagram.this.popupitem = EditLadderDiagram.this.active_eventitem;
                            if (EditLadderDiagram.this.popupitem == null) {
                                EditLadderDiagram.this.popupitem = EditLadderDiagram.this.getSelectedLadderEvent(mouseEvent.getX(), mouseEvent.getY());
                                if (EditLadderDiagram.this.popupitem == null) {
                                    EditLadderDiagram.this.popupitem = EditLadderDiagram.this.getSelectedLadderPath(mouseEvent.getX(), mouseEvent.getY(), 5);
                                }
                            }
                            EditLadderDiagram.this.adjustPopup(EditLadderDiagram.this.popupitem);
                            EditLadderDiagram.this.popup.show(EditLadderDiagram.this, mouseEvent.getX(), mouseEvent.getY());
                            break;
                        }
                        case 4: {
                            ErrorDialog.handleFatalException(new JuggleExceptionInternal("tried to enter POPUP state while already in it"));
                        }
                    }
                } else {
                    switch (EditLadderDiagram.this.gui_state) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            EditLadderDiagram.this.gui_state = 1;
                            if (EditLadderDiagram.this.delta_y == 0) break;
                            EditLadderDiagram.this.moveEvent(EditLadderDiagram.this.active_eventitem.eventitem);
                            for (int i = 0; i < EditLadderDiagram.this.laddereventitems.size(); ++i) {
                                LadderEventItem ladderEventItem = (LadderEventItem)EditLadderDiagram.this.laddereventitems.get(i);
                                if (ladderEventItem.eventitem != EditLadderDiagram.this.active_eventitem.eventitem) continue;
                                ladderEventItem.ylow += EditLadderDiagram.this.delta_y;
                                ladderEventItem.yhigh += EditLadderDiagram.this.delta_y;
                            }
                            EditLadderDiagram.this.delta_y = 0;
                            EditLadderDiagram.this.activeEventMoved();
                            EditLadderDiagram.this.repaint();
                            break;
                        }
                        case 3: {
                            EditLadderDiagram.this.gui_state = 0;
                            if (EditLadderDiagram.this.animator == null) break;
                            EditLadderDiagram.this.animator.setPaused(EditLadderDiagram.this.anim_paused);
                            break;
                        }
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (EditLadderDiagram.this.animator != null && EditLadderDiagram.this.animator.writingGIF) {
                    return;
                }
                int n = mouseEvent.getY();
                if (n < 25) {
                    n = 25;
                } else if (n > EditLadderDiagram.this.height - 25) {
                    n = EditLadderDiagram.this.height - 25;
                }
                switch (EditLadderDiagram.this.gui_state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ErrorDialog.handleFatalException(new JuggleExceptionInternal("mouse dragged in EVENT_SELECTED state"));
                        break;
                    }
                    case 2: {
                        int n2 = EditLadderDiagram.this.delta_y;
                        EditLadderDiagram.this.delta_y = mouseEvent.getY() - EditLadderDiagram.this.start_y;
                        if (EditLadderDiagram.this.delta_y < EditLadderDiagram.this.delta_y_min) {
                            EditLadderDiagram.this.delta_y = EditLadderDiagram.this.delta_y_min;
                        }
                        if (EditLadderDiagram.this.delta_y > EditLadderDiagram.this.delta_y_max) {
                            EditLadderDiagram.this.delta_y = EditLadderDiagram.this.delta_y_max;
                        }
                        if (EditLadderDiagram.this.delta_y == n2) break;
                        EditLadderDiagram.this.repaint();
                        break;
                    }
                    case 3: {
                        EditLadderDiagram.this.tracker_y = n;
                        EditLadderDiagram.this.repaint();
                        if (EditLadderDiagram.this.animator == null) break;
                        double d = (jMLPattern2.getLoopEndTime() - jMLPattern2.getLoopStartTime()) / (double)(EditLadderDiagram.this.height - 50);
                        double d2 = (double)(n - 25) * d;
                        EditLadderDiagram.this.animator.setTime(d2);
                        EditLadderDiagram.this.animator.repaint();
                        break;
                    }
                }
            }
        });
    }

    protected void findEventLimits(LadderEventItem ladderEventItem) {
        double d = this.pat.getLoopStartTime();
        double d2 = this.pat.getLoopEndTime();
        double d3 = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        block4: for (int i = 0; i < ladderEventItem.event.getNumberOfTransitions(); ++i) {
            JMLTransition jMLTransition = ladderEventItem.event.getTransition(i);
            switch (jMLTransition.getType()) {
                case 1: {
                    double d4;
                    JMLEvent jMLEvent;
                    for (jMLEvent = ladderEventItem.event.getPrevious(); jMLEvent != null && jMLEvent.getPathTransition(jMLTransition.getPath(), 2) == null && jMLEvent.getPathTransition(jMLTransition.getPath(), 3) == null; jMLEvent = jMLEvent.getPrevious()) {
                    }
                    if (jMLEvent == null) {
                        ErrorDialog.handleFatalException(new JuggleExceptionInternal("Null event 1 in mousePressed()"));
                    }
                    if ((d4 = jMLEvent.getT() + 0.05) > d) {
                        d = d4;
                    }
                    if (this.sameMaster(jMLEvent = jMLTransition.getOutgoingPathLink().getEndEvent(), ladderEventItem.event) || !((d4 = jMLEvent.getT() - 0.05) < d2)) continue block4;
                    d2 = d4;
                    continue block4;
                }
                case 2: 
                case 3: {
                    double d4;
                    JMLEvent jMLEvent = jMLTransition.getIncomingPathLink().getStartEvent();
                    if (!this.sameMaster(jMLEvent, ladderEventItem.event) && (d4 = jMLEvent.getT() + 0.05) > d) {
                        d = d4;
                    }
                    for (jMLEvent = ladderEventItem.event.getNext(); jMLEvent != null && jMLEvent.getPathTransition(jMLTransition.getPath(), 1) == null; jMLEvent = jMLEvent.getNext()) {
                    }
                    if (jMLEvent == null) {
                        ErrorDialog.handleFatalException(new JuggleExceptionInternal("Null event 2 in mousePressed()"));
                    }
                    if (!((d4 = jMLEvent.getT() - 0.05) < d2)) continue block4;
                    d2 = d4;
                }
            }
        }
        this.delta_y_min = (int)((d - ladderEventItem.event.getT()) / d3);
        this.delta_y_max = (int)((d2 - ladderEventItem.event.getT()) / d3);
    }

    private boolean sameMaster(JMLEvent jMLEvent, JMLEvent jMLEvent2) {
        JMLEvent jMLEvent3 = jMLEvent.isMaster() ? jMLEvent : jMLEvent.getMaster();
        JMLEvent jMLEvent4 = jMLEvent2.isMaster() ? jMLEvent2 : jMLEvent2.getMaster();
        return jMLEvent3 == jMLEvent4;
    }

    protected void moveEvent(LadderEventItem ladderEventItem) {
        Object object;
        JMLTransition jMLTransition;
        int n;
        JMLEvent jMLEvent = ladderEventItem.event;
        double d = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        double d2 = (double)this.delta_y * d;
        double d3 = jMLEvent.getT() + d2;
        if (d3 < this.pat.getLoopStartTime()) {
            d2 = this.pat.getLoopStartTime() - jMLEvent.getT();
            d3 = this.pat.getLoopStartTime();
        } else if (d3 >= this.pat.getLoopEndTime()) {
            d2 = this.pat.getLoopEndTime() - 1.0E-4 - jMLEvent.getT();
            d3 = this.pat.getLoopEndTime() - 1.0E-4;
        }
        boolean[] blArray = new boolean[this.pat.getNumberOfPaths()];
        boolean[] blArray2 = new boolean[this.pat.getNumberOfPaths()];
        boolean[] blArray3 = new boolean[this.pat.getNumberOfPaths()];
        boolean[] blArray4 = new boolean[this.pat.getNumberOfPaths()];
        block15: for (n = 0; n < jMLEvent.getNumberOfTransitions(); ++n) {
            jMLTransition = jMLEvent.getTransition(n);
            switch (jMLTransition.getType()) {
                case 1: {
                    blArray[jMLTransition.getPath() - 1] = true;
                    continue block15;
                }
                case 2: 
                case 3: {
                    blArray2[jMLTransition.getPath() - 1] = true;
                    continue block15;
                }
                case 4: {
                    blArray3[jMLTransition.getPath() - 1] = true;
                    blArray4[jMLTransition.getPath() - 1] = true;
                }
            }
        }
        if (this.delta_y < 0) {
            for (jMLEvent = jMLEvent.getPrevious(); jMLEvent != null && jMLEvent.getT() > d3; jMLEvent = jMLEvent.getPrevious()) {
                if (this.sameMaster(jMLEvent, ladderEventItem.event) || jMLEvent.getJuggler() != ladderEventItem.event.getJuggler() || jMLEvent.getHand() != ladderEventItem.event.getHand()) continue;
                block17: for (n = 0; n < jMLEvent.getNumberOfTransitions(); ++n) {
                    jMLTransition = jMLEvent.getTransition(n);
                    switch (jMLTransition.getType()) {
                        case 1: {
                            blArray4[jMLTransition.getPath() - 1] = true;
                            continue block17;
                        }
                        case 2: 
                        case 3: {
                            blArray4[jMLTransition.getPath() - 1] = false;
                            continue block17;
                        }
                        case 4: {
                            if (!blArray[jMLTransition.getPath() - 1]) continue block17;
                            jMLEvent.removeTransition(n);
                            if (!jMLEvent.isMaster()) {
                                jMLEvent.getMaster().removeTransition(n);
                            }
                            --n;
                        }
                    }
                }
                for (n = 0; n < this.pat.getNumberOfPaths(); ++n) {
                    if (!blArray2[n]) continue;
                    jMLTransition = new JMLTransition(4, n + 1, null, null);
                    jMLEvent.addTransition(jMLTransition);
                    if (jMLEvent.isMaster()) continue;
                    object = jMLEvent.getPathPermFromMaster().getInverse();
                    jMLTransition = new JMLTransition(4, ((Permutation)object).getMapping(n + 1), null, null);
                    jMLEvent.getMaster().addTransition(jMLTransition);
                }
            }
        } else if (this.delta_y > 0) {
            for (jMLEvent = jMLEvent.getNext(); jMLEvent != null && jMLEvent.getT() < d3; jMLEvent = jMLEvent.getNext()) {
                if (this.sameMaster(jMLEvent, ladderEventItem.event) || jMLEvent.getJuggler() != ladderEventItem.event.getJuggler() || jMLEvent.getHand() != ladderEventItem.event.getHand()) continue;
                block20: for (n = 0; n < jMLEvent.getNumberOfTransitions(); ++n) {
                    jMLTransition = jMLEvent.getTransition(n);
                    switch (jMLTransition.getType()) {
                        case 1: {
                            blArray4[jMLTransition.getPath() - 1] = false;
                            continue block20;
                        }
                        case 2: 
                        case 3: {
                            blArray4[jMLTransition.getPath() - 1] = true;
                            continue block20;
                        }
                        case 4: {
                            if (!blArray2[jMLTransition.getPath() - 1]) continue block20;
                            jMLEvent.removeTransition(n);
                            if (!jMLEvent.isMaster()) {
                                jMLEvent.getMaster().removeTransition(n);
                            }
                            --n;
                        }
                    }
                }
                for (n = 0; n < this.pat.getNumberOfPaths(); ++n) {
                    if (!blArray[n]) continue;
                    jMLTransition = new JMLTransition(4, n + 1, null, null);
                    jMLEvent.addTransition(jMLTransition);
                    if (jMLEvent.isMaster()) continue;
                    object = jMLEvent.getPathPermFromMaster().getInverse();
                    jMLTransition = new JMLTransition(4, ((Permutation)object).getMapping(n + 1), null, null);
                    jMLEvent.getMaster().addTransition(jMLTransition);
                }
            }
        }
        jMLEvent = ladderEventItem.event;
        Permutation permutation = jMLEvent.getPathPermFromMaster().getInverse();
        if (!jMLEvent.isMaster()) {
            jMLEvent = jMLEvent.getMaster();
        }
        for (int i = 0; i < this.pat.getNumberOfPaths(); ++i) {
            if (blArray4[i] == blArray3[i]) continue;
            if (blArray4[i]) {
                object = new JMLTransition(4, permutation.getMapping(i + 1), null, null);
                jMLEvent.addTransition((JMLTransition)object);
                continue;
            }
            object = jMLEvent.getPathTransition(permutation.getMapping(i + 1), 4);
            if (object == null) {
                ErrorDialog.handleFatalException(new JuggleExceptionInternal("Null transition in removing hold"));
            }
            jMLEvent.removeTransition((JMLTransition)object);
        }
        this.pat.removeEvent(jMLEvent);
        jMLEvent.setT(jMLEvent.getT() + d2);
        this.pat.addEvent(jMLEvent);
    }

    protected void setupPopup() {
        this.popup = new JPopupMenu();
        this.popupmenuitems = new JMenuItem[popupItems.length];
        for (int i = 0; i < popupItems.length; ++i) {
            String string = popupItems[i];
            if (string != null) {
                JMenuItem jMenuItem = new JMenuItem(guistrings.getString(string.replace(' ', '_')));
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                this.popupmenuitems[i] = jMenuItem;
                continue;
            }
            this.popup.addSeparator();
        }
        this.popup.setBorder(new BevelBorder(0));
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (EditLadderDiagram.this.gui_state == 4) {
                    int n = EditLadderDiagram.this.gui_state = EditLadderDiagram.this.active_eventitem == null ? 0 : 1;
                    if (EditLadderDiagram.this.animator != null) {
                        EditLadderDiagram.this.animator.setPaused(EditLadderDiagram.this.anim_paused);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    protected void adjustPopup(LadderItem ladderItem) {
        int n;
        for (n = 0; n < this.popupmenuitems.length; ++n) {
            if (this.popupmenuitems[n] == null) continue;
            this.popupmenuitems[n].setEnabled(true);
        }
        if (ladderItem == null) {
            for (n = 5; n < this.popupmenuitems.length; ++n) {
                if (this.popupmenuitems[n] == null) continue;
                this.popupmenuitems[n].setEnabled(false);
            }
            return;
        }
        block0 : switch (ladderItem.type) {
            case 1: {
                int n2;
                LadderEventItem ladderEventItem = (LadderEventItem)ladderItem;
                for (n2 = 0; n2 < 4; ++n2) {
                    if (this.popupmenuitems[n2] == null) continue;
                    this.popupmenuitems[n2].setEnabled(false);
                }
                for (n2 = 7; n2 < this.popupmenuitems.length; ++n2) {
                    if (this.popupmenuitems[n2] == null) continue;
                    this.popupmenuitems[n2].setEnabled(false);
                }
                for (n2 = 0; n2 < ladderEventItem.event.getNumberOfTransitions(); ++n2) {
                    JMLTransition jMLTransition = ladderEventItem.event.getTransition(n2);
                    if (jMLTransition.getType() == 4) continue;
                    this.popupmenuitems[5].setEnabled(false);
                    break;
                }
                if (!this.popupmenuitems[5].isEnabled()) break;
                n2 = ladderEventItem.event.getHand();
                int n3 = ladderEventItem.event.getJuggler();
                JMLEvent jMLEvent = ladderEventItem.event.isMaster() ? ladderEventItem.event : ladderEventItem.event.getMaster();
                for (JMLEvent jMLEvent2 = ladderEventItem.event.getNext(); jMLEvent2 != null; jMLEvent2 = jMLEvent2.getNext()) {
                    JMLEvent jMLEvent3;
                    if (jMLEvent2.getHand() != n2 || jMLEvent2.getJuggler() != n3) continue;
                    JMLEvent jMLEvent4 = jMLEvent3 = jMLEvent2.isMaster() ? jMLEvent2 : jMLEvent2.getMaster();
                    if (jMLEvent != jMLEvent3) break block0;
                    this.popupmenuitems[5].setEnabled(false);
                    break block0;
                }
                break;
            }
            case 2: {
                LadderEventItem ladderEventItem = (LadderEventItem)ladderItem;
                JMLTransition jMLTransition = ladderEventItem.event.getTransition(ladderEventItem.transnum);
                for (int i = 0; i < 6; ++i) {
                    if (this.popupmenuitems[i] == null) continue;
                    this.popupmenuitems[i].setEnabled(false);
                }
                if (ladderEventItem.transnum == ladderEventItem.event.getNumberOfTransitions() - 1) {
                    this.popupmenuitems[8].setEnabled(false);
                }
                if (jMLTransition.getType() != 1) {
                    this.popupmenuitems[9].setEnabled(false);
                }
                if (jMLTransition.getType() != 3) {
                    this.popupmenuitems[10].setEnabled(false);
                }
                if (jMLTransition.getType() == 2) break;
                this.popupmenuitems[11].setEnabled(false);
                break;
            }
            default: {
                this.popupmenuitems[5].setEnabled(false);
                for (n = 8; n < this.popupmenuitems.length; ++n) {
                    if (this.popupmenuitems[n] == null) continue;
                    this.popupmenuitems[n].setEnabled(false);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < popupItems.length; ++i) {
            if (popupItems[i] == null || !string.equals(guistrings.getString(popupItems[i].replace(' ', '_')))) continue;
            n = i;
            break;
        }
        switch (n) {
            case 0: {
                this.changeTitle();
                break;
            }
            case 1: {
                this.changeTiming();
                break;
            }
            case 2: {
                JMLEvent jMLEvent = this.addEventToHand(1);
                this.active_eventitem = null;
                if (this.animator != null) {
                    this.animator.deactivateEvent();
                }
                this.layoutPattern();
                this.createView();
                this.repaint();
                break;
            }
            case 3: {
                JMLEvent jMLEvent = this.addEventToHand(2);
                this.active_eventitem = null;
                if (this.animator != null) {
                    this.animator.deactivateEvent();
                }
                this.layoutPattern();
                this.createView();
                this.repaint();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (!(this.popupitem instanceof LadderEventItem)) {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("LadderDiagram remove event class format"));
                    return;
                }
                JMLEvent jMLEvent = ((LadderEventItem)this.popupitem).event;
                if (!jMLEvent.isMaster()) {
                    jMLEvent = jMLEvent.getMaster();
                }
                this.pat.removeEvent(jMLEvent);
                this.active_eventitem = null;
                if (this.animator != null) {
                    this.animator.deactivateEvent();
                }
                this.layoutPattern();
                this.createView();
                this.repaint();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.defineProp();
                break;
            }
            case 8: {
                if (this.popupitem == null) {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("No popupitem in case 8"));
                    return;
                }
                if (!(this.popupitem instanceof LadderEventItem)) {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("LadderDiagram make last transition class format"));
                    return;
                }
                JMLEvent jMLEvent = ((LadderEventItem)this.popupitem).event;
                if (!jMLEvent.isMaster()) {
                    jMLEvent = jMLEvent.getMaster();
                }
                JMLTransition jMLTransition = jMLEvent.getTransition(((LadderEventItem)this.popupitem).transnum);
                jMLEvent.removeTransition(jMLTransition);
                jMLEvent.addTransition(jMLTransition);
                this.active_eventitem = null;
                if (this.animator != null) {
                    this.animator.deactivateEvent();
                }
                this.layoutPattern();
                this.createView();
                this.repaint();
                break;
            }
            case 9: {
                this.defineThrow();
                break;
            }
            case 10: {
                if (this.popupitem == null) {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("No popupitem in case 10"));
                    return;
                }
                if (!(this.popupitem instanceof LadderEventItem)) {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("LadderDiagram change to catch class format"));
                    return;
                }
                JMLEvent jMLEvent = ((LadderEventItem)this.popupitem).event;
                if (!jMLEvent.isMaster()) {
                    jMLEvent = jMLEvent.getMaster();
                }
                int n2 = ((LadderEventItem)this.popupitem).transnum;
                JMLTransition jMLTransition = jMLEvent.getTransition(((LadderEventItem)this.popupitem).transnum);
                jMLTransition.setType(2);
                this.active_eventitem = null;
                if (this.animator != null) {
                    this.animator.deactivateEvent();
                }
                this.layoutPattern();
                this.createView();
                this.repaint();
                break;
            }
            case 11: {
                if (this.popupitem == null) {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("No popupitem in case 11"));
                    return;
                }
                if (!(this.popupitem instanceof LadderEventItem)) {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("LadderDiagram change to softcatch class format"));
                    return;
                }
                JMLEvent jMLEvent = ((LadderEventItem)this.popupitem).event;
                if (!jMLEvent.isMaster()) {
                    jMLEvent = jMLEvent.getMaster();
                }
                int n3 = ((LadderEventItem)this.popupitem).transnum;
                JMLTransition jMLTransition = jMLEvent.getTransition(((LadderEventItem)this.popupitem).transnum);
                jMLTransition.setType(3);
                this.active_eventitem = null;
                if (this.animator != null) {
                    this.animator.deactivateEvent();
                }
                this.layoutPattern();
                this.createView();
                this.repaint();
            }
        }
        this.popupitem = null;
        if (this.gui_state == 4) {
            int n4 = this.gui_state = this.active_eventitem == null ? 0 : 1;
            if (this.animator != null) {
                this.animator.setPaused(this.anim_paused);
            }
        }
    }

    protected void changeTitle() {
        final JDialog jDialog = new JDialog(this.parent, guistrings.getString("Change_title"), true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jDialog.getContentPane().setLayout(gridBagLayout);
        final JTextField jTextField = new JTextField(20);
        jTextField.setText(this.pat.getTitle());
        JButton jButton = new JButton(guistrings.getString("OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                EditLadderDiagram.this.pat.setTitle(string);
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add(jTextField);
        gridBagLayout.setConstraints(jTextField, EditLadderDiagram.make_constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jDialog.getContentPane().add(jButton);
        gridBagLayout.setConstraints(jButton, EditLadderDiagram.make_constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        this.parent.setTitle(this.pat.getTitle());
    }

    protected void changeTiming() {
        double d;
        final JDialog jDialog = new JDialog(this.parent, guistrings.getString("Change_timing"), true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jDialog.getContentPane().setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(guistrings.getString("Rescale_percentage"));
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jLabel, EditLadderDiagram.make_constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        JTextField jTextField = new JTextField(7);
        jPanel.add(jTextField);
        gridBagLayout.setConstraints(jTextField, EditLadderDiagram.make_constraints(21, 1, 0, new Insets(0, 5, 0, 0)));
        JButton jButton = new JButton(guistrings.getString("OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add(jPanel);
        gridBagLayout.setConstraints(jPanel, EditLadderDiagram.make_constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jDialog.getContentPane().add(jButton);
        gridBagLayout.setConstraints(jButton, EditLadderDiagram.make_constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.pack();
        jDialog.setVisible(true);
        try {
            d = Double.valueOf(jTextField.getText()) / 100.0;
        }
        catch (NumberFormatException numberFormatException) {
            new ErrorDialog(this, "Number format error in rescale percentage");
            return;
        }
        if (d > 0.0) {
            for (JMLEvent jMLEvent = this.pat.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
                if (!jMLEvent.isMaster()) continue;
                jMLEvent.setT(jMLEvent.getT() * d);
            }
            for (JMLPosition jMLPosition = this.pat.getPositionList(); jMLPosition != null; jMLPosition = jMLPosition.getNext()) {
                jMLPosition.setT(jMLPosition.getT() * d);
            }
            for (int i = 0; i < this.pat.getNumberOfSymmetries(); ++i) {
                JMLSymmetry jMLSymmetry = this.pat.getSymmetry(i);
                double d2 = jMLSymmetry.getDelay();
                if (!(d2 > 0.0)) continue;
                jMLSymmetry.setDelay(d2 * d);
                if (!(d2 * d < this.animator.getTime())) continue;
                this.animator.setTime(0.0);
            }
            this.layoutPattern();
            this.createView();
        }
    }

    protected JMLEvent addEventToHand(int n) {
        int n2 = 1;
        double d = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.height - 50);
        double d2 = (double)(this.popup_y - 25) * d;
        Coordinate coordinate = new Coordinate();
        try {
            this.pat.getHandCoordinate(n2, n, d2, coordinate);
        }
        catch (JuggleExceptionInternal juggleExceptionInternal) {
            ErrorDialog.handleFatalException(juggleExceptionInternal);
        }
        JMLEvent jMLEvent = new JMLEvent();
        jMLEvent.setLocalCoordinate(this.pat.convertGlobalToLocal(coordinate, n2, d2));
        jMLEvent.setT(d2);
        jMLEvent.setHand(n2, n);
        this.pat.addEvent(jMLEvent);
        for (int i = 0; i < this.pat.getNumberOfPaths(); ++i) {
            JMLTransition jMLTransition;
            boolean bl = false;
            for (JMLEvent jMLEvent2 = jMLEvent.getPrevious(); jMLEvent2 != null; jMLEvent2 = jMLEvent2.getPrevious()) {
                jMLTransition = jMLEvent2.getPathTransition(i + 1, 5);
                if (jMLTransition == null) continue;
                if (jMLEvent2.getJuggler() != jMLEvent.getJuggler() || jMLEvent2.getHand() != jMLEvent.getHand()) {
                    bl = false;
                    break;
                }
                if (jMLTransition.getType() == 1) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            if (!bl) continue;
            jMLTransition = new JMLTransition(4, i + 1, null, null);
            jMLEvent.addTransition(jMLTransition);
        }
        return jMLEvent;
    }

    protected void defineProp() {
        if (this.popupitem == null) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("defineProp() null popupitem"));
            return;
        }
        int n = 0;
        if (this.popupitem instanceof LadderEventItem) {
            if (this.popupitem.type != 2) {
                ErrorDialog.handleFatalException(new JuggleExceptionInternal("defineProp() bad LadderItem type"));
                return;
            }
            JMLEvent jMLEvent = ((LadderEventItem)this.popupitem).event;
            int n2 = ((LadderEventItem)this.popupitem).transnum;
            JMLTransition jMLTransition = jMLEvent.getTransition(n2);
            n = jMLTransition.getPath();
        } else {
            n = ((LadderPathItem)this.popupitem).pathnum;
        }
        final int n3 = n;
        final int[] nArray = this.animator.anim.getAnimPropNum();
        final int n4 = nArray[n3 - 1];
        final Prop prop = this.pat.getProp(n4);
        final boolean bl = this.animator.getPaused();
        this.animator.setPaused(true);
        String[] stringArray = Prop.builtinProps;
        final JDialog jDialog = new JDialog(this.parent, guistrings.getString("Define_prop"), true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jDialog.getContentPane().setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(guistrings.getString("Prop_type"));
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jLabel, EditLadderDiagram.make_constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        final JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jPanel.add(jComboBox);
        gridBagLayout.setConstraints(jComboBox, EditLadderDiagram.make_constraints(21, 1, 0, new Insets(0, 10, 0, 0)));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox.getItemAt(jComboBox.getSelectedIndex());
                try {
                    Prop prop2 = string.equalsIgnoreCase(prop.getType()) ? prop : Prop.newProp(string);
                    EditLadderDiagram.this.makeParametersPanel(jPanel2, prop2.getParameterDescriptors());
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(jDialog, juggleExceptionUser.getMessage());
                    return;
                }
                jDialog.pack();
            }
        });
        String[] stringArray2 = Prop.builtinProps;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equalsIgnoreCase(prop.getType())) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        JButton jButton = new JButton(guistrings.getString("Cancel"));
        jPanel3.add(jButton);
        gridBagLayout.setConstraints(jButton, EditLadderDiagram.make_constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                EditLadderDiagram.this.animator.setPaused(bl);
            }
        });
        JButton jButton2 = new JButton(guistrings.getString("OK"));
        jPanel3.add(jButton2);
        gridBagLayout.setConstraints(jButton2, EditLadderDiagram.make_constraints(22, 1, 0, new Insets(0, 10, 0, 0)));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                String string = (String)jComboBox.getItemAt(jComboBox.getSelectedIndex());
                String string2 = null;
                try {
                    string2 = EditLadderDiagram.this.getParameterList();
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(EditLadderDiagram.this.parent, juggleExceptionUser.getMessage());
                    return;
                }
                for (n2 = 0; n2 < EditLadderDiagram.this.pat.getNumberOfPaths(); ++n2) {
                    EditLadderDiagram.this.pat.setPropAssignment(n2 + 1, nArray[n2]);
                }
                n2 = 1;
                for (n = 0; n < EditLadderDiagram.this.pat.getNumberOfPaths(); ++n) {
                    if (n == n3 - 1 || nArray[n] != n4) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0) {
                    EditLadderDiagram.this.pat.removeProp(n4);
                }
                n = 0;
                int n32 = 0;
                for (int i = 1; i <= EditLadderDiagram.this.pat.getNumberOfProps(); ++i) {
                    PropDef propDef = EditLadderDiagram.this.pat.getPropDef(i);
                    if (!string.equalsIgnoreCase(propDef.getType()) || (string2 != null || propDef.getMod() != null) && (string2 == null || !string2.equalsIgnoreCase(propDef.getMod()))) continue;
                    n = 1;
                    n32 = i;
                    break;
                }
                if (n != 0) {
                    EditLadderDiagram.this.pat.setPropAssignment(n3, n32);
                } else {
                    PropDef propDef = new PropDef(string.toLowerCase(), string2);
                    EditLadderDiagram.this.pat.addProp(propDef);
                    EditLadderDiagram.this.pat.setPropAssignment(n3, EditLadderDiagram.this.pat.getNumberOfProps());
                }
                EditLadderDiagram.this.layoutPattern();
                jDialog.dispose();
                EditLadderDiagram.this.animator.setPaused(bl);
            }
        });
        jDialog.getContentPane().add(jPanel);
        gridBagLayout.setConstraints(jPanel, EditLadderDiagram.make_constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jDialog.getContentPane().add(jPanel2);
        gridBagLayout.setConstraints(jPanel2, EditLadderDiagram.make_constraints(21, 0, 1, new Insets(0, 0, 0, 0)));
        jDialog.getContentPane().add(jPanel3);
        gridBagLayout.setConstraints(jPanel3, EditLadderDiagram.make_constraints(22, 0, 2, new Insets(10, 10, 10, 10)));
        jDialog.getRootPane().setDefaultButton(jButton2);
        Locale locale = JLLocale.getLocale();
        jDialog.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        this.dialog_controls = null;
    }

    protected void defineThrow() {
        if (!(this.popupitem instanceof LadderEventItem)) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal("defineThrow() class format"));
            return;
        }
        JMLEvent jMLEvent = ((LadderEventItem)this.popupitem).event;
        if (!jMLEvent.isMaster()) {
            jMLEvent = jMLEvent.getMaster();
        }
        final JMLTransition jMLTransition = jMLEvent.getTransition(((LadderEventItem)this.popupitem).transnum);
        String[] stringArray = Path.builtinPaths;
        final JDialog jDialog = new JDialog(this.parent, guistrings.getString("Define_throw"), true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jDialog.getContentPane().setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(guistrings.getString("Throw_type"));
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jLabel, EditLadderDiagram.make_constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        final JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jPanel.add(jComboBox);
        gridBagLayout.setConstraints(jComboBox, EditLadderDiagram.make_constraints(21, 1, 0, new Insets(0, 10, 0, 0)));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox.getItemAt(jComboBox.getSelectedIndex());
                try {
                    Path path = string.equalsIgnoreCase(jMLTransition.getThrowType()) ? jMLTransition.getOutgoingPathLink().getPath() : Path.newPath(string);
                    EditLadderDiagram.this.makeParametersPanel(jPanel2, path.getParameterDescriptors());
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(jDialog, juggleExceptionUser.getMessage());
                    return;
                }
                jDialog.pack();
            }
        });
        String[] stringArray2 = Path.builtinPaths;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equalsIgnoreCase(jMLTransition.getThrowType())) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        JButton jButton = new JButton(guistrings.getString("Cancel"));
        jPanel3.add(jButton);
        gridBagLayout.setConstraints(jButton, EditLadderDiagram.make_constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        JButton jButton2 = new JButton(guistrings.getString("OK"));
        jPanel3.add(jButton2);
        gridBagLayout.setConstraints(jButton2, EditLadderDiagram.make_constraints(22, 1, 0, new Insets(0, 10, 0, 0)));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox.getItemAt(jComboBox.getSelectedIndex());
                jMLTransition.setThrowType(string.toLowerCase());
                String string2 = null;
                try {
                    string2 = EditLadderDiagram.this.getParameterList();
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(EditLadderDiagram.this.parent, juggleExceptionUser.getMessage());
                    return;
                }
                jMLTransition.setMod(string2);
                EditLadderDiagram.this.layoutPattern();
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add(jPanel);
        gridBagLayout.setConstraints(jPanel, EditLadderDiagram.make_constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jDialog.getContentPane().add(jPanel2);
        gridBagLayout.setConstraints(jPanel2, EditLadderDiagram.make_constraints(21, 0, 1, new Insets(0, 0, 0, 0)));
        jDialog.getContentPane().add(jPanel3);
        gridBagLayout.setConstraints(jPanel3, EditLadderDiagram.make_constraints(22, 0, 2, new Insets(10, 10, 10, 10)));
        jDialog.getRootPane().setDefaultButton(jButton2);
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        this.dialog_controls = null;
    }

    protected void makeParametersPanel(JPanel jPanel, ParameterDescriptor[] parameterDescriptorArray) {
        jPanel.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.dialog_controls = new ArrayList();
        this.dialog_pd = parameterDescriptorArray;
        if (parameterDescriptorArray.length != 0) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(gridBagLayout);
            block0: for (int i = 0; i < parameterDescriptorArray.length; ++i) {
                Object object;
                Object object2;
                JLabel jLabel = new JLabel(parameterDescriptorArray[i].name);
                jPanel2.add(jLabel);
                gridBagLayout.setConstraints(jLabel, EditLadderDiagram.make_constraints(21, 0, i, new Insets(0, 0, 0, 0)));
                if (parameterDescriptorArray[i].type == 1) {
                    object2 = new JCheckBox();
                    jPanel2.add((Component)object2);
                    gridBagLayout.setConstraints((Component)object2, EditLadderDiagram.make_constraints(21, 1, i, new Insets(2, 5, 2, 0)));
                    this.dialog_controls.add((JComponent)object2);
                    boolean bl = (Boolean)parameterDescriptorArray[i].value;
                    ((AbstractButton)object2).setSelected(bl);
                    continue;
                }
                if (parameterDescriptorArray[i].type == 2) {
                    object2 = new JTextField(7);
                    jPanel2.add((Component)object2);
                    gridBagLayout.setConstraints((Component)object2, EditLadderDiagram.make_constraints(21, 1, i, new Insets(0, 5, 0, 0)));
                    this.dialog_controls.add((JComponent)object2);
                    Double d = (Double)parameterDescriptorArray[i].value;
                    ((JTextComponent)object2).setText(d.toString());
                    continue;
                }
                if (parameterDescriptorArray[i].type == 3) {
                    object2 = new String[parameterDescriptorArray[i].range.size()];
                    parameterDescriptorArray[i].range.toArray((T[])object2);
                    JComboBox<String> jComboBox = new JComboBox<String>((E[])object2);
                    jPanel2.add(jComboBox);
                    gridBagLayout.setConstraints(jComboBox, EditLadderDiagram.make_constraints(21, 1, i, new Insets(0, 5, 0, 0)));
                    this.dialog_controls.add(jComboBox);
                    object = (String)parameterDescriptorArray[i].value;
                    for (int j = 0; j < ((Object)object2).length; ++j) {
                        if (!((String)object).equalsIgnoreCase((String)object2[j])) continue;
                        jComboBox.setSelectedIndex(j);
                        continue block0;
                    }
                    continue;
                }
                if (parameterDescriptorArray[i].type == 4) {
                    object2 = new JTextField(4);
                    jPanel2.add((Component)object2);
                    gridBagLayout.setConstraints((Component)object2, EditLadderDiagram.make_constraints(21, 1, i, new Insets(0, 5, 0, 0)));
                    this.dialog_controls.add((JComponent)object2);
                    Integer n = (Integer)parameterDescriptorArray[i].value;
                    ((JTextComponent)object2).setText(n.toString());
                    ((JTextComponent)object2).addCaretListener(new CaretListener(){

                        @Override
                        public void caretUpdate(CaretEvent caretEvent) {
                        }
                    });
                    continue;
                }
                if (parameterDescriptorArray[i].type != 5) continue;
                object2 = parameterDescriptorArray[i];
                final ParameterDescriptor[] parameterDescriptorArray2 = parameterDescriptorArray;
                object = jPanel;
                URL uRL = (URL)((ParameterDescriptor)object2).value;
                ImageIcon imageIcon = new ImageIcon(uRL, uRL.toString());
                if ((float)imageIcon.getIconHeight() > 100.0f) {
                    float f = 100.0f / (float)imageIcon.getIconHeight();
                    int n = (int)(f * (float)imageIcon.getIconHeight());
                    int n2 = (int)(f * (float)imageIcon.getIconWidth());
                    imageIcon.setImage(imageIcon.getImage().getScaledInstance(n2, n, 4));
                }
                JLabel jLabel2 = new JLabel(imageIcon);
                jLabel2.addMouseListener(new MouseAdapter((JPanel)object){
                    final /* synthetic */ JPanel val$fjp;
                    {
                        this.val$fjp = jPanel;
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        FileFilter fileFilter = new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
                                String string = "";
                                while (stringTokenizer.hasMoreTokens()) {
                                    string = stringTokenizer.nextToken();
                                }
                                return string.equals("jpg") || string.equals("gif") || string.equals("png") || file.isDirectory();
                            }

                            @Override
                            public String getDescription() {
                                return "Image Files";
                            }
                        };
                        PlatformSpecific platformSpecific = PlatformSpecific.getPlatformSpecific();
                        int n = platformSpecific.showOpenDialog(EditLadderDiagram.this, fileFilter);
                        if (n == 0) {
                            try {
                                URL uRL = platformSpecific.getSelectedFile().toURI().toURL();
                                ImageIcon imageIcon = new ImageIcon(uRL, uRL.toString());
                                parameterDescriptorArray2[0].value = uRL;
                                EditLadderDiagram.this.makeParametersPanel(this.val$fjp, parameterDescriptorArray2);
                                ((JDialog)this.val$fjp.getTopLevelAncestor()).pack();
                            }
                            catch (MalformedURLException malformedURLException) {
                                ErrorDialog.handleFatalException(new JuggleExceptionUser(errorstrings.getString("Error_malformed_URL.")));
                            }
                        }
                    }
                });
                jPanel2.add(jLabel2);
                gridBagLayout.setConstraints(jLabel2, EditLadderDiagram.make_constraints(21, 1, i, new Insets(0, 5, 5, 0)));
                this.dialog_controls.add(jLabel2);
            }
            jPanel.add(jPanel2);
            gridBagLayout.setConstraints(jPanel2, EditLadderDiagram.make_constraints(21, 0, 1, new Insets(10, 10, 0, 10)));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String getParameterList() throws JuggleExceptionUser {
        var1_1 = null;
        for (var2_2 = 0; var2_2 < this.dialog_pd.length; ++var2_2) {
            var3_3 = null;
            var4_4 = this.dialog_controls.get(var2_2);
            if (this.dialog_pd[var2_2].type == 1) {
                var5_5 = (JCheckBox)var4_4;
                var6_6 = var5_5.isSelected();
                if (var6_6 != (var7_13 = ((Boolean)this.dialog_pd[var2_2].default_value).booleanValue())) {
                    var3_3 = new Boolean(var6_6).toString();
                }
            } else if (this.dialog_pd[var2_2].type == 2) {
                var5_5 = (JTextField)var4_4;
                try {
                    var6_7 = Double.valueOf(var5_5.getText());
                    var8_19 = (Double)this.dialog_pd[var2_2].default_value;
                    if (var6_7 == var8_19) ** GOTO lbl48
                    var3_3 = var5_5.getText().trim();
                }
                catch (NumberFormatException var6_8) {
                    var7_14 = EditLadderDiagram.errorstrings.getString("Error_number_format");
                    var8_20 = new Object[]{this.dialog_pd[var2_2].name};
                    throw new JuggleExceptionUser(MessageFormat.format(var7_14, var8_20));
                }
            } else if (this.dialog_pd[var2_2].type == 3) {
                var5_5 = (JComboBox)var4_4;
                var6_9 = var5_5.getSelectedIndex();
                var7_15 = this.dialog_pd[var2_2].range.get(var6_9);
                if (!var7_15.equalsIgnoreCase(var8_21 = (String)this.dialog_pd[var2_2].default_value)) {
                    var3_3 = var7_15;
                }
            } else if (this.dialog_pd[var2_2].type == 4) {
                var5_5 = (JTextField)var4_4;
                try {
                    var6_10 = Integer.valueOf(var5_5.getText());
                    var7_16 = (Integer)this.dialog_pd[var2_2].default_value;
                    if (var6_10 == var7_16) ** GOTO lbl48
                    var3_3 = var5_5.getText().trim();
                }
                catch (NumberFormatException var6_11) {
                    var7_17 = EditLadderDiagram.errorstrings.getString("Error_number_format");
                    var8_22 = new Object[]{this.dialog_pd[var2_2].name};
                    throw new JuggleExceptionUser(MessageFormat.format(var7_17, var8_22));
                }
            } else if (this.dialog_pd[var2_2].type == 5) {
                var5_5 = (JLabel)var4_4;
                var6_12 = (ImageIcon)var5_5.getIcon();
                var7_18 = ((URL)this.dialog_pd[var2_2].default_value).toString();
                if (!var6_12.getDescription().equals(var7_18)) {
                    var3_3 = var6_12.getDescription();
                }
            }
lbl48:
            // 11 sources

            if (var3_3 == null) continue;
            var3_3 = this.dialog_pd[var2_2].name + "=" + var3_3;
            var1_1 = var1_1 == null ? var3_3 : var1_1 + ";" + var3_3;
        }
        return var1_1;
    }

    protected static GridBagConstraints make_constraints(int n, int n2, int n3, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return gridBagConstraints;
    }

    public void setAnimationPanel(AnimationEditPanel animationEditPanel) {
        this.animator = animationEditPanel;
    }

    public void activeEventMoved() {
        if (this.active_eventitem == null || this.animator == null) {
            return;
        }
        int n = (this.active_eventitem.xlow + this.active_eventitem.xhigh) / 2;
        int n2 = (this.active_eventitem.ylow + this.active_eventitem.yhigh) / 2;
        this.layoutPattern();
        this.createView();
        this.active_eventitem = this.getSelectedLadderEvent(n, n2);
        this.animator.activateEvent(this.active_eventitem.event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutPattern() {
        try {
            JMLPattern jMLPattern = this.pat;
            synchronized (jMLPattern) {
                this.pat.layoutPattern();
            }
            if (this.animator != null) {
                this.animator.anim.initAnimator();
                this.animator.repaint();
            }
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal(juggleExceptionUser.getMessage()));
        }
        catch (JuggleExceptionInternal juggleExceptionInternal) {
            ErrorDialog.handleFatalException(juggleExceptionInternal);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        Object object;
        if (graphics instanceof Graphics2D) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.pat.getNumberOfJugglers() > 1) {
            Dimension dimension = this.getSize();
            int n2 = dimension.width;
            int n3 = dimension.height;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth("Not available");
            int n5 = n2 > n4 ? (n2 - n4) / 2 : 0;
            int n6 = (n3 + fontMetrics.getHeight()) / 2;
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n2, n3);
            graphics.setColor(Color.black);
            graphics.drawString("Not available", n5, n6);
            return;
        }
        this.paintBackground(graphics);
        object = this.animator.anim.getAnimPropNum();
        graphics.setColor(Color.black);
        for (n = 0; n < this.laddereventitems.size(); ++n) {
            int n7;
            LadderEventItem ladderEventItem = (LadderEventItem)this.laddereventitems.get(n);
            int n8 = n7 = this.gui_state == 2 && this.active_eventitem.eventitem == ladderEventItem.eventitem ? this.delta_y : 0;
            if (ladderEventItem.type == 1) {
                graphics.fillOval(ladderEventItem.xlow, ladderEventItem.ylow + n7, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
                continue;
            }
            if (ladderEventItem.ylow + n7 < 25 && ladderEventItem.yhigh + n7 > this.height + 25) continue;
            JMLTransition jMLTransition = ladderEventItem.event.getTransition(ladderEventItem.transnum);
            int n9 = jMLTransition.getPath();
            Object object2 = object[n9 - 1];
            graphics.setColor(this.pat.getProp((int)object2).getEditorColor());
            graphics.fillOval(ladderEventItem.xlow, ladderEventItem.ylow + n7, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
            graphics.setColor(Color.black);
            graphics.drawOval(ladderEventItem.xlow, ladderEventItem.ylow + n7, ladderEventItem.xhigh - ladderEventItem.xlow, ladderEventItem.yhigh - ladderEventItem.ylow);
        }
        if (this.active_eventitem != null) {
            n = this.gui_state == 2 ? this.delta_y : 0;
            graphics.setColor(Color.green);
            graphics.drawLine(this.active_eventitem.xlow - 1, this.active_eventitem.ylow + n - 1, this.active_eventitem.xhigh + 1, this.active_eventitem.ylow + n - 1);
            graphics.drawLine(this.active_eventitem.xhigh + 1, this.active_eventitem.ylow + n - 1, this.active_eventitem.xhigh + 1, this.active_eventitem.yhigh + n + 1);
            graphics.drawLine(this.active_eventitem.xhigh + 1, this.active_eventitem.yhigh + n + 1, this.active_eventitem.xlow, this.active_eventitem.yhigh + n + 1);
            graphics.drawLine(this.active_eventitem.xlow - 1, this.active_eventitem.yhigh + n + 1, this.active_eventitem.xlow - 1, this.active_eventitem.ylow + n - 1);
        }
        graphics.setColor(Color.red);
        graphics.drawLine(0, this.tracker_y, this.width, this.tracker_y);
    }
}

