/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.ApplicationPanel;
import jugglinglab.core.PatternList;
import jugglinglab.core.PatternListWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.core.PlatformSpecific;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.Pattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.LabelDialog;
import jugglinglab.util.UpdateChecker;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ApplicationWindow
extends JFrame
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final String[] fileItems = new String[]{"Open JML...", null, "Quit"};
    protected static final String[] fileCommands = new String[]{"open", null, "exit"};
    protected static final char[] fileShortcuts = new char[]{'O', ' ', 'Q'};
    protected static final String[] helpItems = new String[]{"About Juggling Lab", "Juggling Lab Online Help"};
    protected static final String[] helpCommands = new String[]{"about", "online"};
    protected static final int FILE_NONE = 0;
    protected static final int FILE_OPEN = 1;
    protected static final int FILE_EXIT = 2;
    protected static final int HELP_ABOUT = 3;
    protected static final int HELP_ONLINE = 4;

    public ApplicationWindow(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        super(string);
        this.createMenus();
        PlatformSpecific.getPlatformSpecific().registerParent(this);
        PlatformSpecific.getPlatformSpecific().setupPlatform();
        ApplicationPanel applicationPanel = new ApplicationPanel(this);
        applicationPanel.setDoubleBuffered(true);
        this.setBackground(new Color(0.9f, 0.9f, 0.9f));
        this.setContentPane(applicationPanel);
        applicationPanel.setNotation(1);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                try {
                    ApplicationWindow.this.doMenuCommand(2);
                }
                catch (Exception exception) {
                    System.exit(0);
                }
            }
        });
        Locale locale = JLLocale.getLocale();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        this.pack();
        this.setResizable(false);
        this.setLocation(100, 50);
        this.setVisible(true);
        new UpdateChecker();
    }

    protected void createMenus() {
        JMenu jMenu;
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        if (Pattern.builtinNotations.length > 1) {
            jMenu = this.createNotationMenu();
            jMenuBar.add(jMenu);
            jMenu.getItem(0).setSelected(true);
        }
        if ((jMenu = this.createHelpMenu()) != null) {
            jMenuBar.add(jMenu);
        }
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu createFileMenu() {
        boolean bl = true;
        JMenu jMenu = new JMenu(guistrings.getString("File"));
        for (int i = 0; i < (bl ? fileItems.length : fileItems.length - 2); ++i) {
            if (fileItems[i] == null) {
                jMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(guistrings.getString(fileItems[i].replace(' ', '_')));
            if (fileShortcuts[i] != ' ') {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            jMenuItem.setActionCommand(fileCommands[i]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    protected JMenu createNotationMenu() {
        JMenu jMenu = new JMenu(guistrings.getString("Notation"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < Pattern.builtinNotations.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(Pattern.builtinNotations[i]);
            jRadioButtonMenuItem.setActionCommand("notation" + (i + 1));
            jRadioButtonMenuItem.addActionListener(this);
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    protected JMenu createHelpMenu() {
        int n;
        boolean bl = true;
        JMenu jMenu = new JMenu(guistrings.getString("Help"));
        int n2 = n = bl ? 0 : 1;
        while (n < helpItems.length) {
            if (helpItems[n] == null) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = new JMenuItem(guistrings.getString(helpItems[n].replace(' ', '_')));
                jMenuItem.setActionCommand(helpCommands[n]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        return jMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("open")) {
                this.doMenuCommand(1);
            } else if (string.equals("exit")) {
                this.doMenuCommand(2);
            } else if (string.equals("about")) {
                this.doMenuCommand(3);
            } else if (string.equals("online")) {
                this.doMenuCommand(4);
            }
        }
        catch (JuggleExceptionInternal juggleExceptionInternal) {
            ErrorDialog.handleFatalException(juggleExceptionInternal);
        }
    }

    protected void doMenuCommand(int n) throws JuggleExceptionInternal {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
                        String string = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                        }
                        return string.equals("jml") || file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "JML Files";
                    }
                };
                try {
                    File file;
                    if (PlatformSpecific.getPlatformSpecific().showOpenDialog(this, fileFilter) != 0 || (file = PlatformSpecific.getPlatformSpecific().getSelectedFile()) == null) break;
                    ApplicationWindow.showJMLWindow(file);
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                }
                break;
            }
            case 2: {
                System.exit(0);
                break;
            }
            case 3: {
                ApplicationWindow.showAboutBox();
                break;
            }
            case 4: {
                boolean bl = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
                boolean bl2 = false;
                if (bl) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://jugglinglab.org/#help"));
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                }
                if (bl && !bl2) break;
                new LabelDialog(this, "Help", "Find online help at https://jugglinglab.org/#help");
            }
        }
    }

    protected static void showJMLWindow(File file) throws JuggleExceptionUser, JuggleExceptionInternal {
        Window window = null;
        Window window2 = null;
        try {
            try {
                JMLParser jMLParser = new JMLParser();
                jMLParser.parse(new FileReader(file));
                switch (jMLParser.getFileType()) {
                    case 1: {
                        JMLNode jMLNode = jMLParser.getTree();
                        JMLPattern jMLPattern = new JMLPattern(jMLNode);
                        window = new PatternWindow(jMLPattern.getTitle(), jMLPattern, new AnimationPrefs());
                        break;
                    }
                    case 2: {
                        JMLNode jMLNode = jMLParser.getTree();
                        window2 = new PatternListWindow(jMLNode);
                        PatternList patternList = ((PatternListWindow)window2).getPatternList();
                        break;
                    }
                    default: {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_invalid_JML"));
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_file_not_found") + ": " + fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_IO") + ": " + iOException.getMessage());
            }
            catch (SAXParseException sAXParseException) {
                String string = errorstrings.getString("Error_parsing");
                Object[] objectArray = new Object[]{new Integer(sAXParseException.getLineNumber())};
                throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
            }
            catch (SAXException sAXException) {
                throw new JuggleExceptionUser(sAXException.getMessage());
            }
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            if (window != null) {
                window.dispose();
            }
            if (window2 != null) {
                window2.dispose();
            }
            throw juggleExceptionUser;
        }
        catch (JuggleExceptionInternal juggleExceptionInternal) {
            if (window != null) {
                window.dispose();
            }
            if (window2 != null) {
                window2.dispose();
            }
            throw juggleExceptionInternal;
        }
    }

    protected static void showAboutBox() {
        Serializable serializable;
        Accessible accessible;
        final JFrame jFrame = new JFrame(guistrings.getString("About_Juggling_Lab"));
        jFrame.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        URL uRL = ApplicationWindow.class.getResource("/about.png");
        if (uRL != null && (accessible = new ImageIcon(uRL, "A lab")) != null) {
            serializable = new JLabel((Icon)((Object)accessible));
            jPanel.add((Component)serializable, "Before");
        }
        accessible = new JPanel();
        jPanel.add((Component)((Object)accessible), "After");
        serializable = new GridBagLayout();
        ((Container)((Object)accessible)).setLayout((LayoutManager)((Object)serializable));
        JLabel jLabel = new JLabel("Juggling Lab");
        jLabel.setFont(new Font("SansSerif", 1, 18));
        ((Container)((Object)accessible)).add(jLabel);
        ((GridBagLayout)serializable).setConstraints(jLabel, JLFunc.constraints(21, 0, 0, new Insets(15, 15, 0, 15)));
        String string = guistrings.getString("Version");
        Object[] objectArray = new Object[]{"1.4.1"};
        JLabel jLabel2 = new JLabel(MessageFormat.format(string, objectArray));
        jLabel2.setFont(new Font("SansSerif", 0, 16));
        ((Container)((Object)accessible)).add(jLabel2);
        ((GridBagLayout)serializable).setConstraints(jLabel2, JLFunc.constraints(21, 0, 1, new Insets(0, 15, 0, 15)));
        String string2 = guistrings.getString("Copyright_message");
        Object[] objectArray2 = new Object[]{"2021"};
        JLabel jLabel3 = new JLabel(MessageFormat.format(string2, objectArray2));
        jLabel3.setFont(new Font("SansSerif", 0, 14));
        ((Container)((Object)accessible)).add(jLabel3);
        ((GridBagLayout)serializable).setConstraints(jLabel3, JLFunc.constraints(21, 0, 2, new Insets(15, 15, 15, 15)));
        JLabel jLabel4 = new JLabel(guistrings.getString("GPL_message"));
        jLabel4.setFont(new Font("SansSerif", 0, 14));
        ((Container)((Object)accessible)).add(jLabel4);
        ((GridBagLayout)serializable).setConstraints(jLabel4, JLFunc.constraints(21, 0, 3, new Insets(0, 15, 0, 15)));
        JButton jButton = new JButton(guistrings.getString("OK"));
        ((Container)((Object)accessible)).add(jButton);
        ((GridBagLayout)serializable).setConstraints(jButton, JLFunc.constraints(22, 0, 4, new Insets(15, 15, 15, 15)));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        jFrame.setContentPane(jPanel);
        Locale locale = JLLocale.getLocale();
        jFrame.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        jFrame.pack();
        jFrame.setResizable(false);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

