/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.PatternList;
import jugglinglab.core.PatternListWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.generator.Generator;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.Transitioner;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.NotationControl;
import jugglinglab.notation.Pattern;
import jugglinglab.notation.SiteswapNotationControl;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionInterrupted;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.LabelDialog;
import jugglinglab.util.ParameterList;
import jugglinglab.view.View;

public class ApplicationPanel
extends JPanel
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected JFrame parent;
    protected JTabbedPane jtp;
    protected View animtarget;
    protected PatternList patlist;
    protected boolean patlisttab = false;
    protected int currentnum = -1;
    protected JButton juggle_button;
    protected JButton trans_button;
    protected JButton gen_button;
    protected JLabel gen_busy;
    protected static final int max_patterns = 1000;
    protected static final double max_time = 15.0;

    public ApplicationPanel(JFrame jFrame) {
        this(jFrame, null, null, false);
    }

    public ApplicationPanel(JFrame jFrame, View view, PatternList patternList, boolean bl) {
        this.parent = jFrame;
        this.animtarget = view;
        this.patlist = patternList;
        bl = patternList == null ? bl : true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            String string = actionEvent.getActionCommand();
            try {
                if (!string.startsWith("notation")) break block6;
                try {
                    int n = Integer.parseInt(string.substring(8));
                    if (n != this.currentnum) {
                        this.setNotation(n);
                        if (this.parent != null) {
                            this.parent.pack();
                        }
                        this.currentnum = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JuggleExceptionInternal("Error in notation number coding");
                }
            }
            catch (Exception exception) {
                ErrorDialog.handleFatalException(exception);
            }
        }
    }

    public void setNotation(int n) throws JuggleExceptionUser, JuggleExceptionInternal {
        Generator generator;
        Transitioner transitioner;
        if (n > Pattern.builtinNotations.length) {
            return;
        }
        if (this.jtp != null) {
            this.remove(this.jtp);
        }
        this.jtp = new JTabbedPane();
        switch (n) {
            case 1: {
                this.addPatternEntryControl(new SiteswapNotationControl());
            }
        }
        PatternList patternList = this.patlist;
        if (patternList == null && this.patlisttab) {
            patternList = new PatternList(this.animtarget);
        }
        if ((transitioner = Transitioner.newTransitioner(Pattern.builtinNotations[n - 1])) != null) {
            this.addTransitionerControl(transitioner, patternList);
        }
        if ((generator = Generator.newGenerator(Pattern.builtinNotations[n - 1])) != null) {
            this.addGeneratorControl(generator, patternList);
        }
        if (patternList != null) {
            this.jtp.addTab(guistrings.getString("Pattern_list_tab"), patternList);
            if (this.patlist != null) {
                this.jtp.setSelectedComponent(patternList);
            }
        }
        this.jtp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ApplicationPanel.this.getRootPane().setDefaultButton(ApplicationPanel.this.getDefaultButton());
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.jtp, "Center");
        if (this.parent != null) {
            this.parent.getRootPane().setDefaultButton(this.getDefaultButton());
        }
    }

    protected void addPatternEntryControl(NotationControl notationControl) {
        final NotationControl notationControl2 = notationControl;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)notationControl, "First");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(4));
        JButton jButton = new JButton(guistrings.getString("Defaults"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    notationControl2.resetControl();
                }
                catch (Exception exception) {
                    ErrorDialog.handleFatalException(exception);
                }
            }
        });
        jPanel2.add(jButton);
        this.juggle_button = new JButton(guistrings.getString("Juggle"));
        this.juggle_button.setDefaultCapable(true);
        this.juggle_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternWindow patternWindow = null;
                try {
                    ParameterList parameterList = notationControl2.getParameterList();
                    Pattern pattern = notationControl2.newPattern().fromParameters(parameterList);
                    AnimationPrefs animationPrefs = new AnimationPrefs().fromParameters(parameterList);
                    parameterList.errorIfParametersLeft();
                    JMLPattern jMLPattern = pattern.asJMLPattern();
                    if (ApplicationPanel.this.animtarget != null) {
                        ApplicationPanel.this.animtarget.restartView(jMLPattern, animationPrefs);
                    } else {
                        patternWindow = new PatternWindow(jMLPattern.getTitle(), jMLPattern, animationPrefs);
                    }
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    if (patternWindow != null) {
                        patternWindow.dispose();
                    }
                    new ErrorDialog(ApplicationPanel.this, juggleExceptionUser.getMessage());
                }
                catch (Exception exception) {
                    if (patternWindow != null) {
                        patternWindow.dispose();
                    }
                    ErrorDialog.handleFatalException(exception);
                }
            }
        });
        jPanel2.add(this.juggle_button);
        jPanel.add((Component)jPanel2, "Last");
        this.jtp.addTab(guistrings.getString("Pattern_entry"), jPanel);
    }

    protected void addTransitionerControl(final Transitioner transitioner, final PatternList patternList) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)transitioner.getTransitionerControl(), "First");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(4));
        JButton jButton = new JButton(guistrings.getString("Defaults"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                transitioner.resetTransitionerControl();
            }
        });
        jPanel2.add(jButton);
        this.trans_button = new JButton(guistrings.getString("Run"));
        this.trans_button.setDefaultCapable(true);
        this.trans_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        ApplicationPanel.this.trans_button.setEnabled(false);
                        Window window = null;
                        try {
                            transitioner.initTransitioner();
                            GeneratorTarget generatorTarget = null;
                            if (patternList != null) {
                                patternList.clearList();
                                generatorTarget = new GeneratorTarget(patternList);
                            } else {
                                String string = transitioner.getNotationName() + " " + guistrings.getString("Patterns");
                                window = new PatternListWindow(string, this);
                                generatorTarget = new GeneratorTarget((PatternListWindow)window);
                            }
                            transitioner.runTransitioner(generatorTarget, 1000, 15.0);
                            if (patternList != null) {
                                ApplicationPanel.this.jtp.setSelectedComponent(patternList);
                            }
                        }
                        catch (JuggleExceptionDone juggleExceptionDone) {
                            if (patternList != null) {
                                ApplicationPanel.this.jtp.setSelectedComponent(patternList);
                            }
                            Container container = window;
                            if (window == null) {
                                container = patternList;
                            }
                            new LabelDialog(container, guistrings.getString("Generator_stopped_title"), juggleExceptionDone.getMessage());
                        }
                        catch (JuggleExceptionInterrupted juggleExceptionInterrupted) {
                        }
                        catch (JuggleExceptionUser juggleExceptionUser) {
                            if (window != null) {
                                window.dispose();
                            }
                            new ErrorDialog(ApplicationPanel.this, juggleExceptionUser.getMessage());
                        }
                        catch (Exception exception) {
                            if (window != null) {
                                window.dispose();
                            }
                            ErrorDialog.handleFatalException(exception);
                        }
                        ApplicationPanel.this.trans_button.setEnabled(true);
                    }
                };
                thread.start();
            }
        });
        jPanel2.add(this.trans_button);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "After");
        jPanel.add((Component)jPanel3, "Last");
        this.jtp.addTab(guistrings.getString("Transitions"), jPanel);
    }

    protected void addGeneratorControl(final Generator generator, final PatternList patternList) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)generator.getGeneratorControl(), "First");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(4));
        JButton jButton = new JButton(guistrings.getString("Defaults"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                generator.resetGeneratorControl();
            }
        });
        jPanel2.add(jButton);
        this.gen_button = new JButton(guistrings.getString("Run"));
        this.gen_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        ApplicationPanel.this.gen_busy.setVisible(true);
                        ApplicationPanel.this.gen_button.setEnabled(false);
                        Window window = null;
                        try {
                            generator.initGenerator();
                            GeneratorTarget generatorTarget = null;
                            if (patternList != null) {
                                patternList.clearList();
                                generatorTarget = new GeneratorTarget(patternList);
                            } else {
                                String string = generator.getNotationName() + " " + guistrings.getString("Patterns");
                                window = new PatternListWindow(string, this);
                                generatorTarget = new GeneratorTarget((PatternListWindow)window);
                            }
                            generator.runGenerator(generatorTarget, 1000, 15.0);
                            if (patternList != null) {
                                ApplicationPanel.this.jtp.setSelectedComponent(patternList);
                            }
                        }
                        catch (JuggleExceptionDone juggleExceptionDone) {
                            if (patternList != null) {
                                ApplicationPanel.this.jtp.setSelectedComponent(patternList);
                            }
                            Container container = window;
                            if (window == null) {
                                container = patternList;
                            }
                            new LabelDialog(container, guistrings.getString("Generator_stopped_title"), juggleExceptionDone.getMessage());
                        }
                        catch (JuggleExceptionInterrupted juggleExceptionInterrupted) {
                        }
                        catch (JuggleExceptionUser juggleExceptionUser) {
                            if (window != null) {
                                window.dispose();
                            }
                            new ErrorDialog(ApplicationPanel.this, juggleExceptionUser.getMessage());
                        }
                        catch (Exception exception) {
                            if (window != null) {
                                window.dispose();
                            }
                            ErrorDialog.handleFatalException(exception);
                        }
                        ApplicationPanel.this.gen_busy.setVisible(false);
                        ApplicationPanel.this.gen_button.setEnabled(true);
                    }
                };
                thread.start();
            }
        });
        jPanel2.add(this.gen_button);
        this.gen_busy = new JLabel(guistrings.getString("Processing"));
        this.gen_busy.setVisible(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        jPanel4.add(this.gen_busy);
        gridBagLayout.setConstraints(this.gen_busy, JLFunc.constraints(21, 0, 0, new Insets(0, 10, 0, 0)));
        jPanel3.add((Component)jPanel4, "Before");
        jPanel3.add((Component)jPanel2, "After");
        jPanel.add((Component)jPanel3, "Last");
        this.jtp.addTab(guistrings.getString("Generator"), jPanel);
    }

    protected JButton getDefaultButton() {
        if (this.jtp == null) {
            return null;
        }
        if (this.jtp.getSelectedIndex() == 0) {
            return this.juggle_button;
        }
        if (this.jtp.getSelectedIndex() == 1) {
            return this.trans_button;
        }
        return this.gen_button;
    }
}

