/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.renderer.Renderer;
import jugglinglab.renderer.Renderer2D;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;
import org.w3c.dom.Node;

public class Animator {
    protected JMLPattern pat;
    protected AnimationPrefs jc;
    protected Renderer ren1;
    protected Renderer ren2;
    protected Coordinate overallmax;
    protected Coordinate overallmin;
    protected int num_frames;
    protected double sim_interval_secs;
    protected long real_interval_millis;
    protected int[] animpropnum;
    protected Permutation invpathperm;
    protected double[] camangle = new double[2];
    protected double[] camangle1 = new double[2];
    protected double[] camangle2 = new double[2];
    protected Dimension dim;

    public Animator() {
        this.jc = new AnimationPrefs();
    }

    public void restartAnimator(JMLPattern jMLPattern, AnimationPrefs animationPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (jMLPattern != null && !jMLPattern.isLaidout()) {
            jMLPattern.layoutPattern();
        }
        if (jMLPattern != null) {
            this.pat = jMLPattern;
        }
        if (animationPrefs != null) {
            this.jc = animationPrefs;
        }
        if (this.pat == null) {
            return;
        }
        boolean bl = this.jc.showGround == 1 || this.jc.showGround == 0 && this.pat.isBouncePattern();
        this.ren1 = new Renderer2D();
        this.ren1.setPattern(this.pat);
        this.ren1.setGround(bl);
        if (this.jc.stereo) {
            this.ren2 = new Renderer2D();
            this.ren2.setPattern(this.pat);
            this.ren2.setGround(bl);
        } else {
            this.ren2 = null;
        }
        this.initAnimator();
        double[] dArray = new double[2];
        if (this.jc.camangle != null) {
            dArray[0] = Math.toRadians(this.jc.camangle[0]);
            double d = Math.min(179.9999, Math.max(1.0E-4, this.jc.camangle[1]));
            dArray[1] = Math.toRadians(d);
        } else if (this.pat.getNumberOfJugglers() == 1) {
            dArray[0] = Math.toRadians(0.0);
            dArray[1] = Math.toRadians(90.0);
        } else {
            dArray[0] = Math.toRadians(340.0);
            dArray[1] = Math.toRadians(70.0);
        }
        this.setCameraAngle(dArray);
    }

    public Dimension getDimension() {
        return new Dimension(this.dim);
    }

    public void setDimension(Dimension dimension) {
        this.dim = new Dimension(dimension);
        if (this.ren1 != null) {
            this.syncRenderersToSize();
        }
    }

    public double[] getCameraAngle() {
        double[] dArray = new double[]{this.camangle[0], this.camangle[1]};
        return dArray;
    }

    protected void setCameraAngle(double[] dArray) {
        while (dArray[0] < 0.0) {
            dArray[0] = dArray[0] + Math.PI * 2;
        }
        while (dArray[0] >= Math.PI * 2) {
            dArray[0] = dArray[0] - Math.PI * 2;
        }
        this.camangle[0] = dArray[0];
        this.camangle[1] = dArray[1];
        if (this.jc.stereo) {
            this.camangle1[0] = dArray[0] - 0.05;
            this.camangle1[1] = dArray[1];
            this.ren1.setCameraAngle(this.camangle1);
            this.camangle2[0] = dArray[0] + 0.05;
            this.camangle2[1] = dArray[1];
            this.ren2.setCameraAngle(this.camangle2);
        } else {
            this.camangle1[0] = dArray[0];
            this.camangle1[1] = dArray[1];
            this.ren1.setCameraAngle(this.camangle1);
        }
    }

    public void drawFrame(double d, Graphics graphics, boolean bl) throws JuggleExceptionInternal {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        double d2;
        double d3;
        double d4;
        Object object;
        Object object2;
        Object object3;
        if (this.jc.stereo) {
            this.ren1.drawFrame(d, this.animpropnum, this.jc.hideJugglers, graphics.create(0, 0, this.dim.width / 2, this.dim.height));
            this.ren2.drawFrame(d, this.animpropnum, this.jc.hideJugglers, graphics.create(this.dim.width / 2, 0, this.dim.width / 2, this.dim.height));
        } else {
            this.ren1.drawFrame(d, this.animpropnum, this.jc.hideJugglers, graphics);
        }
        if (bl) {
            if (graphics instanceof Graphics2D) {
                object3 = (Graphics2D)graphics;
                ((Graphics2D)object3).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            object3 = this.ren1.getCameraAngle();
            object2 = object3[0];
            object = object3[1];
            d4 = 30.0;
            d3 = d4 * Math.cos((double)object);
            d2 = d4 * Math.sin((double)object);
            n8 = 38;
            n7 = 45;
            n6 = n8 + (int)(0.5 - d4 * Math.cos((double)object2));
            n5 = n7 + (int)(0.5 + d3 * Math.sin((double)object2));
            n4 = n8 + (int)(0.5 + d4 * Math.sin((double)object2));
            n3 = n7 + (int)(0.5 + d3 * Math.cos((double)object2));
            n2 = n8;
            n = n7 - (int)(0.5 + d2);
            graphics.setColor(Color.green);
            graphics.drawLine(n8, n7, n6, n5);
            graphics.drawLine(n8, n7, n4, n3);
            graphics.drawLine(n8, n7, n2, n);
            graphics.fillOval(n6 - 2, n5 - 2, 5, 5);
            graphics.fillOval(n4 - 2, n3 - 2, 5, 5);
            graphics.fillOval(n2 - 2, n - 2, 5, 5);
            graphics.drawString("x", n6 - 2, n5 - 4);
            graphics.drawString("y", n4 - 2, n3 - 4);
            graphics.drawString("z", n2 - 2, n - 4);
        }
        if (this.jc.stereo && bl) {
            object3 = this.ren2.getCameraAngle();
            object2 = object3[0];
            object = object3[1];
            d4 = 30.0;
            d3 = d4 * Math.cos((double)object);
            d2 = d4 * Math.sin((double)object);
            n8 = 38 + this.dim.width / 2;
            n7 = 45;
            n6 = n8 + (int)(0.5 - d4 * Math.cos((double)object2));
            n5 = n7 + (int)(0.5 + d3 * Math.sin((double)object2));
            n4 = n8 + (int)(0.5 + d4 * Math.sin((double)object2));
            n3 = n7 + (int)(0.5 + d3 * Math.cos((double)object2));
            n2 = n8;
            n = n7 - (int)(0.5 + d2);
            graphics.setColor(Color.green);
            graphics.drawLine(n8, n7, n6, n5);
            graphics.drawLine(n8, n7, n4, n3);
            graphics.drawLine(n8, n7, n2, n);
            graphics.fillOval(n6 - 2, n5 - 2, 5, 5);
            graphics.fillOval(n4 - 2, n3 - 2, 5, 5);
            graphics.fillOval(n2 - 2, n - 2, 5, 5);
            graphics.drawString("x", n6 - 2, n5 - 4);
            graphics.drawString("y", n4 - 2, n3 - 4);
            graphics.drawString("z", n2 - 2, n - 4);
        }
    }

    public void advanceProps() {
        int n;
        int n2 = this.pat.getNumberOfPaths();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[this.invpathperm.getMapping((int)(n + 1)) - 1] = this.animpropnum[n];
        }
        for (n = 0; n < n2; ++n) {
            this.animpropnum[n] = nArray[n];
        }
    }

    public void initAnimator() {
        this.findMaxMin();
        this.syncRenderersToSize();
        this.num_frames = (int)(0.5 + (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) * this.jc.slowdown * this.jc.fps);
        this.sim_interval_secs = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)this.num_frames;
        this.real_interval_millis = (long)(1000.0 * this.sim_interval_secs * this.jc.slowdown);
        this.animpropnum = new int[this.pat.getNumberOfPaths()];
        for (int i = 0; i < this.pat.getNumberOfPaths(); ++i) {
            this.animpropnum[i] = this.pat.getPropAssignment(i + 1);
        }
        this.invpathperm = this.pat.getPathPermutation().getInverse();
    }

    private void findMaxMin() {
        int n;
        Coordinate coordinate = null;
        Coordinate coordinate2 = null;
        Coordinate coordinate3 = null;
        Coordinate coordinate4 = null;
        Coordinate coordinate5 = null;
        Coordinate coordinate6 = null;
        for (n = 1; n <= this.pat.getNumberOfPaths(); ++n) {
            coordinate = Coordinate.max(coordinate, this.pat.getPathMax(n));
            coordinate2 = Coordinate.min(coordinate2, this.pat.getPathMin(n));
        }
        for (n = 1; n <= this.pat.getNumberOfJugglers(); ++n) {
            coordinate3 = Coordinate.max(coordinate3, this.pat.getHandMax(n, 1));
            coordinate4 = Coordinate.min(coordinate4, this.pat.getHandMin(n, 1));
            coordinate3 = Coordinate.max(coordinate3, this.pat.getHandMax(n, 2));
            coordinate4 = Coordinate.min(coordinate4, this.pat.getHandMin(n, 2));
        }
        for (n = 1; n <= this.pat.getNumberOfProps(); ++n) {
            coordinate5 = Coordinate.max(coordinate5, this.pat.getProp(n).getMax());
            coordinate6 = Coordinate.min(coordinate6, this.pat.getProp(n).getMin());
        }
        coordinate = Coordinate.add(coordinate, coordinate5);
        coordinate2 = Coordinate.add(coordinate2, coordinate6);
        coordinate3 = Coordinate.add(coordinate3, this.ren1.getHandWindowMax());
        coordinate4 = Coordinate.add(coordinate4, this.ren1.getHandWindowMin());
        this.overallmax = Coordinate.max(coordinate3, this.ren1.getJugglerWindowMax());
        this.overallmax = Coordinate.max(this.overallmax, coordinate);
        this.overallmin = Coordinate.min(coordinate4, this.ren1.getJugglerWindowMin());
        this.overallmin = Coordinate.min(this.overallmin, coordinate2);
        if (this.pat.getNumberOfJugglers() == 1) {
            this.overallmin.z -= 0.3 * Math.max(Math.abs(this.overallmin.y), Math.abs(this.overallmax.y));
            this.overallmax.z += 5.0;
        } else {
            double d = Math.max(Math.abs(this.overallmin.x), Math.abs(this.overallmax.x));
            double d2 = Math.max(Math.abs(this.overallmin.y), Math.abs(this.overallmax.y));
            this.overallmin.z -= 0.4 * Math.max(d, d2);
            this.overallmax.z += 0.4 * Math.max(d, d2);
        }
        double d = Math.max(Math.abs(this.overallmin.x), Math.abs(this.overallmax.x));
        this.overallmin.x = -d;
        this.overallmax.x = d;
    }

    private void syncRenderersToSize() {
        Dimension dimension = new Dimension(this.dim);
        if (this.jc.stereo) {
            dimension.width /= 2;
            this.ren1.initDisplay(dimension, this.jc.border, this.overallmax, this.overallmin);
            this.ren2.initDisplay(dimension, this.jc.border, this.overallmax, this.overallmin);
        } else {
            this.ren1.initDisplay(dimension, this.jc.border, this.overallmax, this.overallmin);
        }
    }

    public int[] getAnimPropNum() {
        return this.animpropnum;
    }

    public Color getBackground() {
        return this.ren1.getBackground();
    }

    public AnimationPrefs getAnimationPrefs() {
        return this.jc;
    }

    public void writeGIF(OutputStream outputStream, WriteGIFMonitor writeGIFMonitor) throws IOException, JuggleExceptionInternal {
        int n;
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("gif").next();
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(outputStream);
        imageWriter.setOutput(memoryCacheImageOutputStream);
        imageWriter.prepareWriteSequence(null);
        BufferedImage bufferedImage = new BufferedImage(this.dim.width, this.dim.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        for (n = 0; n < this.pat.getNumberOfPaths(); ++n) {
            this.animpropnum[n] = this.pat.getPropAssignment(n + 1);
        }
        n = this.pat.getPeriod() * this.num_frames;
        int n2 = 0;
        String string = String.valueOf((int)(0.5 + (double)(this.real_interval_millis / 10L)));
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        IIOMetadata iIOMetadata = null;
        for (int i = 0; i < this.pat.getPeriod(); ++i) {
            double d = this.pat.getLoopStartTime();
            for (int j = 0; j < this.num_frames; ++j) {
                this.drawFrame(d, graphics2D, false);
                if (n2 < 2) {
                    iIOMetadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), imageWriteParam);
                    Animator.configureGIFMetadata(iIOMetadata, string, n2);
                }
                IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
                imageWriter.writeToSequence(iIOImage, null);
                d += this.sim_interval_secs;
                ++n2;
                if (writeGIFMonitor == null) continue;
                writeGIFMonitor.update(n2, n);
                if (!writeGIFMonitor.isCanceled()) continue;
                memoryCacheImageOutputStream.close();
                outputStream.close();
                return;
            }
            this.advanceProps();
        }
        graphics2D.dispose();
        imageWriter.endWriteSequence();
        memoryCacheImageOutputStream.close();
        outputStream.close();
    }

    private static void configureGIFMetadata(IIOMetadata iIOMetadata, String string, int n) {
        Node node;
        String string2 = iIOMetadata.getNativeMetadataFormatName();
        if (!"javax_imageio_gif_image_1.0".equals(string2)) {
            throw new IllegalArgumentException("Unfamiliar gif metadata format: " + string2);
        }
        Node node2 = iIOMetadata.getAsTree(string2);
        for (node = node2.getFirstChild(); node != null && !"GraphicControlExtension".equals(node.getNodeName()); node = node.getNextSibling()) {
        }
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
        iIOMetadataNode.setAttribute("userInputFlag", "FALSE");
        iIOMetadataNode.setAttribute("delayTime", string);
        if (n == 0) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ApplicationExtensions");
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ApplicationExtension");
            iIOMetadataNode3.setAttribute("applicationID", "NETSCAPE");
            iIOMetadataNode3.setAttribute("authenticationCode", "2.0");
            byte[] byArray = new byte[]{1, 0, 0};
            iIOMetadataNode3.setUserObject(byArray);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            node2.appendChild(iIOMetadataNode2);
        }
        try {
            iIOMetadata.setFromTree(string2, node2);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            throw new Error(iIOInvalidTreeException);
        }
    }

    public static interface WriteGIFMonitor {
        public void update(int var1, int var2);

        public boolean isCanceled();
    }
}

