/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;

public class AnimationPrefsDialog
extends JDialog {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected JTextField tf_width;
    protected JTextField tf_height;
    protected JTextField tf_fps;
    protected JTextField tf_slowdown;
    protected JTextField tf_border;
    protected JCheckBox cb_paused;
    protected JCheckBox cb_mousepause;
    protected JCheckBox cb_stereo;
    protected JCheckBox cb_catchsounds;
    protected JCheckBox cb_bouncesounds;
    protected JComboBox<String> combo_showground;
    protected JButton but_cancel;
    protected JButton but_ok;
    protected AnimationPrefs newjc;
    protected static final int border = 10;

    public AnimationPrefsDialog(JFrame jFrame) {
        super(jFrame, guistrings.getString("Animation_Preferences"), true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(guistrings.getString("Width"));
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jLabel, AnimationPrefsDialog.make_constraints(21, 1, 0, new Insets(0, 3, 0, 0)));
        this.tf_width = new JTextField(4);
        this.tf_width.setHorizontalAlignment(0);
        jPanel.add(this.tf_width);
        gridBagLayout.setConstraints(this.tf_width, AnimationPrefsDialog.make_constraints(21, 0, 0, new Insets(0, 0, 0, 0)));
        JLabel jLabel2 = new JLabel(guistrings.getString("Height"));
        jPanel.add(jLabel2);
        gridBagLayout.setConstraints(jLabel2, AnimationPrefsDialog.make_constraints(21, 1, 1, new Insets(0, 3, 0, 0)));
        this.tf_height = new JTextField(4);
        this.tf_height.setHorizontalAlignment(0);
        jPanel.add(this.tf_height);
        gridBagLayout.setConstraints(this.tf_height, AnimationPrefsDialog.make_constraints(21, 0, 1, new Insets(0, 0, 0, 0)));
        JLabel jLabel3 = new JLabel(guistrings.getString("Frames_per_second"));
        jPanel.add(jLabel3);
        gridBagLayout.setConstraints(jLabel3, AnimationPrefsDialog.make_constraints(21, 1, 2, new Insets(0, 3, 0, 0)));
        this.tf_fps = new JTextField(4);
        this.tf_fps.setHorizontalAlignment(0);
        jPanel.add(this.tf_fps);
        gridBagLayout.setConstraints(this.tf_fps, AnimationPrefsDialog.make_constraints(21, 0, 2, new Insets(0, 0, 0, 0)));
        JLabel jLabel4 = new JLabel(guistrings.getString("Slowdown_factor"));
        jPanel.add(jLabel4);
        gridBagLayout.setConstraints(jLabel4, AnimationPrefsDialog.make_constraints(21, 1, 3, new Insets(0, 3, 0, 0)));
        this.tf_slowdown = new JTextField(4);
        this.tf_slowdown.setHorizontalAlignment(0);
        jPanel.add(this.tf_slowdown);
        gridBagLayout.setConstraints(this.tf_slowdown, AnimationPrefsDialog.make_constraints(21, 0, 3, new Insets(0, 0, 0, 0)));
        JLabel jLabel5 = new JLabel(guistrings.getString("Border_(pixels)"));
        jPanel.add(jLabel5);
        gridBagLayout.setConstraints(jLabel5, AnimationPrefsDialog.make_constraints(21, 1, 4, new Insets(0, 3, 0, 0)));
        this.tf_border = new JTextField(4);
        this.tf_border.setHorizontalAlignment(0);
        jPanel.add(this.tf_border);
        gridBagLayout.setConstraints(this.tf_border, AnimationPrefsDialog.make_constraints(21, 0, 4, new Insets(0, 0, 0, 0)));
        JLabel jLabel6 = new JLabel(guistrings.getString("Prefs_show_ground"));
        jPanel.add(jLabel6);
        gridBagLayout.setConstraints(jLabel6, AnimationPrefsDialog.make_constraints(21, 1, 5, new Insets(0, 3, 0, 0)));
        this.combo_showground = new JComboBox();
        this.combo_showground.addItem(guistrings.getString("Prefs_show_ground_auto"));
        this.combo_showground.addItem(guistrings.getString("Prefs_show_ground_yes"));
        this.combo_showground.addItem(guistrings.getString("Prefs_show_ground_no"));
        jPanel.add(this.combo_showground);
        gridBagLayout.setConstraints(this.combo_showground, AnimationPrefsDialog.make_constraints(21, 0, 5, new Insets(0, 0, 0, 0)));
        this.cb_paused = new JCheckBox(guistrings.getString("Start_paused"));
        this.cb_mousepause = new JCheckBox(guistrings.getString("Pause_on_mouse_away"));
        this.cb_stereo = new JCheckBox(guistrings.getString("Stereo_display"));
        this.cb_catchsounds = new JCheckBox(guistrings.getString("Catch_sounds"));
        this.cb_bouncesounds = new JCheckBox(guistrings.getString("Bounce_sounds"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        this.but_cancel = new JButton(guistrings.getString("Cancel"));
        this.but_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimationPrefsDialog.this.setVisible(false);
            }
        });
        jPanel2.add(this.but_cancel);
        gridBagLayout.setConstraints(this.but_cancel, AnimationPrefsDialog.make_constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        this.but_ok = new JButton(guistrings.getString("OK"));
        this.but_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d;
                Object[] objectArray;
                String string;
                int n;
                AnimationPrefsDialog.this.setVisible(false);
                AnimationPrefsDialog.this.newjc = new AnimationPrefs(AnimationPrefsDialog.this.newjc);
                try {
                    n = Integer.parseInt(AnimationPrefsDialog.this.tf_width.getText());
                    if (n >= 0) {
                        AnimationPrefsDialog.this.newjc.width = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = errorstrings.getString("Error_number_format");
                    objectArray = new Object[]{"width"};
                    new ErrorDialog(AnimationPrefsDialog.this, MessageFormat.format(string, objectArray));
                }
                try {
                    n = Integer.parseInt(AnimationPrefsDialog.this.tf_height.getText());
                    if (n >= 0) {
                        AnimationPrefsDialog.this.newjc.height = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = errorstrings.getString("Error_number_format");
                    objectArray = new Object[]{"height"};
                    new ErrorDialog(AnimationPrefsDialog.this, MessageFormat.format(string, objectArray));
                }
                try {
                    d = Double.parseDouble(AnimationPrefsDialog.this.tf_fps.getText());
                    if (d > 0.0) {
                        AnimationPrefsDialog.this.newjc.fps = d;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = errorstrings.getString("Error_number_format");
                    objectArray = new Object[]{"fps"};
                    new ErrorDialog(AnimationPrefsDialog.this, MessageFormat.format(string, objectArray));
                }
                try {
                    d = Double.parseDouble(AnimationPrefsDialog.this.tf_slowdown.getText());
                    if (d > 0.0) {
                        AnimationPrefsDialog.this.newjc.slowdown = d;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = errorstrings.getString("Error_number_format");
                    objectArray = new Object[]{"slowdown"};
                    new ErrorDialog(AnimationPrefsDialog.this, MessageFormat.format(string, objectArray));
                }
                try {
                    n = Integer.parseInt(AnimationPrefsDialog.this.tf_border.getText());
                    if (n >= 0) {
                        AnimationPrefsDialog.this.newjc.border = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = errorstrings.getString("Error_number_format");
                    objectArray = new Object[]{"border"};
                    new ErrorDialog(AnimationPrefsDialog.this, MessageFormat.format(string, objectArray));
                }
                AnimationPrefsDialog.this.newjc.showGround = AnimationPrefsDialog.this.combo_showground.getSelectedIndex();
                AnimationPrefsDialog.this.newjc.startPause = AnimationPrefsDialog.this.cb_paused.isSelected();
                AnimationPrefsDialog.this.newjc.mousePause = AnimationPrefsDialog.this.cb_mousepause.isSelected();
                AnimationPrefsDialog.this.newjc.stereo = AnimationPrefsDialog.this.cb_stereo.isSelected();
                AnimationPrefsDialog.this.newjc.catchSound = AnimationPrefsDialog.this.cb_catchsounds.isSelected();
                AnimationPrefsDialog.this.newjc.bounceSound = AnimationPrefsDialog.this.cb_bouncesounds.isSelected();
            }
        });
        jPanel2.add(this.but_ok);
        gridBagLayout.setConstraints(this.but_ok, AnimationPrefsDialog.make_constraints(22, 1, 0, new Insets(0, 10, 0, 0)));
        this.getContentPane().add(jPanel);
        gridBagLayout.setConstraints(jPanel, AnimationPrefsDialog.make_constraints(21, 0, 0, new Insets(3, 10, 0, 10)));
        this.getContentPane().add(this.cb_paused);
        gridBagLayout.setConstraints(this.cb_paused, AnimationPrefsDialog.make_constraints(21, 0, 1, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb_mousepause);
        gridBagLayout.setConstraints(this.cb_mousepause, AnimationPrefsDialog.make_constraints(21, 0, 2, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb_stereo);
        gridBagLayout.setConstraints(this.cb_stereo, AnimationPrefsDialog.make_constraints(21, 0, 3, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb_catchsounds);
        gridBagLayout.setConstraints(this.cb_catchsounds, AnimationPrefsDialog.make_constraints(21, 0, 4, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb_bouncesounds);
        gridBagLayout.setConstraints(this.cb_bouncesounds, AnimationPrefsDialog.make_constraints(21, 0, 5, new Insets(0, 10, 3, 10)));
        this.getContentPane().add(jPanel2);
        gridBagLayout.setConstraints(jPanel2, AnimationPrefsDialog.make_constraints(22, 0, 6, new Insets(0, 10, 10, 10)));
        this.getRootPane().setDefaultButton(this.but_ok);
        Locale locale = JLLocale.getLocale();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(jFrame);
    }

    protected static GridBagConstraints make_constraints(int n, int n2, int n3, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return gridBagConstraints;
    }

    public AnimationPrefs getPrefs(AnimationPrefs animationPrefs) {
        this.newjc = animationPrefs;
        this.tf_width.setText(Integer.toString(animationPrefs.width));
        this.tf_height.setText(Integer.toString(animationPrefs.height));
        this.tf_fps.setText(Double.toString(animationPrefs.fps));
        this.tf_slowdown.setText(Double.toString(animationPrefs.slowdown));
        this.tf_border.setText(Integer.toString(animationPrefs.border));
        this.combo_showground.setSelectedIndex(animationPrefs.showGround);
        this.cb_paused.setSelected(animationPrefs.startPause);
        this.cb_mousepause.setSelected(animationPrefs.mousePause);
        this.cb_stereo.setSelected(animationPrefs.stereo);
        this.cb_catchsounds.setSelected(animationPrefs.catchSound);
        this.cb_bouncesounds.setSelected(animationPrefs.bounceSound);
        this.setVisible(true);
        return this.newjc;
    }
}

