/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import jugglinglab.JugglingLab;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.view.View;

public class AnimationPrefs {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final int GROUND_AUTO = 0;
    public static final int GROUND_ON = 1;
    public static final int GROUND_OFF = 2;
    public static final int width_def = 400;
    public static final int height_def = 450;
    public static final double fps_def;
    public static final double slowdown_def = 2.0;
    public static final int border_def = 0;
    public static final int showGround_def = 0;
    public static final boolean stereo_def = false;
    public static final boolean startPause_def = false;
    public static final boolean mousePause_def = false;
    public static final boolean catchSound_def = false;
    public static final boolean bounceSound_def;
    public static final int view_def = 0;
    public int width = 400;
    public int height = 450;
    public double fps = fps_def;
    public double slowdown = 2.0;
    public int border = 0;
    public int showGround = 0;
    public boolean stereo = false;
    public boolean startPause = false;
    public boolean mousePause = false;
    public boolean catchSound = false;
    public boolean bounceSound = bounceSound_def;
    public double[] camangle;
    public int view = 0;
    public int[] hideJugglers;

    public AnimationPrefs() {
    }

    public AnimationPrefs(AnimationPrefs animationPrefs) {
        if (animationPrefs.width > 0) {
            this.width = animationPrefs.width;
        }
        if (animationPrefs.height > 0) {
            this.height = animationPrefs.height;
        }
        if (animationPrefs.slowdown >= 0.0) {
            this.slowdown = animationPrefs.slowdown;
        }
        if (animationPrefs.fps >= 0.0) {
            this.fps = animationPrefs.fps;
        }
        if (animationPrefs.border >= 0) {
            this.border = animationPrefs.border;
        }
        this.showGround = animationPrefs.showGround;
        this.stereo = animationPrefs.stereo;
        this.startPause = animationPrefs.startPause;
        this.mousePause = animationPrefs.mousePause;
        this.catchSound = animationPrefs.catchSound;
        this.bounceSound = animationPrefs.bounceSound;
        if (animationPrefs.camangle != null) {
            this.camangle = (double[])animationPrefs.camangle.clone();
        }
        this.view = animationPrefs.view;
        if (animationPrefs.hideJugglers != null) {
            this.hideJugglers = (int[])animationPrefs.hideJugglers.clone();
        }
    }

    public AnimationPrefs fromParameters(ParameterList parameterList) throws JuggleExceptionUser {
        int n;
        Object[] objectArray;
        int n2;
        double d;
        String string = null;
        string = parameterList.removeParameter("stereo");
        if (string != null) {
            this.stereo = Boolean.parseBoolean(string);
        }
        if ((string = parameterList.removeParameter("startpaused")) != null) {
            this.startPause = Boolean.parseBoolean(string);
        }
        if ((string = parameterList.removeParameter("mousepause")) != null) {
            this.mousePause = Boolean.parseBoolean(string);
        }
        if ((string = parameterList.removeParameter("catchsound")) != null) {
            this.catchSound = Boolean.parseBoolean(string);
        }
        if ((string = parameterList.removeParameter("bouncesound")) != null) {
            this.bounceSound = Boolean.parseBoolean(string);
        }
        if ((string = parameterList.removeParameter("fps")) != null) {
            try {
                this.fps = d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = errorstrings.getString("Error_number_format");
                Object[] objectArray2 = new Object[]{"fps"};
                throw new JuggleExceptionUser(MessageFormat.format(string2, objectArray2));
            }
        }
        if ((string = parameterList.removeParameter("slowdown")) != null) {
            try {
                this.slowdown = d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = errorstrings.getString("Error_number_format");
                Object[] objectArray3 = new Object[]{"slowdown"};
                throw new JuggleExceptionUser(MessageFormat.format(string3, objectArray3));
            }
        }
        if ((string = parameterList.removeParameter("border")) != null) {
            try {
                this.border = n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = errorstrings.getString("Error_number_format");
                Object[] objectArray4 = new Object[]{"border"};
                throw new JuggleExceptionUser(MessageFormat.format(string4, objectArray4));
            }
        }
        if ((string = parameterList.removeParameter("width")) != null) {
            try {
                this.width = n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = errorstrings.getString("Error_number_format");
                Object[] objectArray5 = new Object[]{"width"};
                throw new JuggleExceptionUser(MessageFormat.format(string5, objectArray5));
            }
        }
        if ((string = parameterList.removeParameter("height")) != null) {
            try {
                this.height = n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string6 = errorstrings.getString("Error_number_format");
                Object[] objectArray6 = new Object[]{"height"};
                throw new JuggleExceptionUser(MessageFormat.format(string6, objectArray6));
            }
        }
        if ((string = parameterList.removeParameter("showground")) != null) {
            if (string.equalsIgnoreCase("auto")) {
                this.showGround = 0;
            } else if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("yes")) {
                this.showGround = 1;
            } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("no")) {
                this.showGround = 2;
            } else {
                String string7 = errorstrings.getString("Error_showground_value");
                Object[] objectArray7 = new Object[]{string};
                throw new JuggleExceptionUser(MessageFormat.format(string7, objectArray7));
            }
        }
        if ((string = parameterList.removeParameter("camangle")) != null) {
            try {
                double[] dArray = new double[2];
                dArray[1] = 90.0;
                string = string.replace("(", "").replace(")", "");
                string = string.replace("{", "").replace("}", "");
                objectArray = new StringTokenizer(string, ",");
                n = objectArray.countTokens();
                if (n > 2) {
                    String string8 = errorstrings.getString("Error_too_many_elements");
                    Object[] objectArray8 = new Object[]{"camangle"};
                    throw new JuggleExceptionUser(MessageFormat.format(string8, objectArray8));
                }
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Double.parseDouble(objectArray.nextToken().trim());
                }
                this.camangle = new double[2];
                this.camangle[0] = dArray[0];
                this.camangle[1] = dArray[1];
            }
            catch (NumberFormatException numberFormatException) {
                String string9 = errorstrings.getString("Error_number_format");
                Object[] objectArray9 = new Object[]{"camangle"};
                throw new JuggleExceptionUser(MessageFormat.format(string9, objectArray9));
            }
        }
        if ((string = parameterList.removeParameter("view")) != null) {
            this.view = -1;
            for (int i = 0; i < View.viewNames.length; ++i) {
                if (!string.equalsIgnoreCase(View.viewNames[i])) continue;
                this.view = i + 1;
            }
            if (this.view == -1) {
                String string10 = errorstrings.getString("Error_unrecognized_view");
                objectArray = new Object[]{"'" + string + "'"};
                throw new JuggleExceptionUser(MessageFormat.format(string10, objectArray));
            }
        }
        if ((string = parameterList.removeParameter("hidejugglers")) != null) {
            string = string.replace("(", "").replace(")", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n3 = stringTokenizer.countTokens();
            this.hideJugglers = new int[n3];
            try {
                for (n = 0; n < n3; ++n) {
                    this.hideJugglers[n] = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string11 = errorstrings.getString("Error_number_format");
                Object[] objectArray10 = new Object[]{"hidejugglers"};
                throw new JuggleExceptionUser(MessageFormat.format(string11, objectArray10));
            }
        }
        return this;
    }

    public String toString() {
        String string = "";
        if (this.width != 400) {
            string = string + "width=" + this.width + ";";
        }
        if (this.height != 450) {
            string = string + "height=" + this.height + ";";
        }
        if (this.fps != fps_def) {
            string = string + "fps=" + JLFunc.toStringTruncated(this.fps, 2) + ";";
        }
        if (this.slowdown != 2.0) {
            string = string + "slowdown=" + JLFunc.toStringTruncated(this.slowdown, 2) + ";";
        }
        if (this.border != 0) {
            string = string + "border=" + this.border + ";";
        }
        if (this.showGround != 0) {
            switch (this.showGround) {
                case 0: {
                    string = string + "showground=auto;";
                    break;
                }
                case 1: {
                    string = string + "showground=true;";
                    break;
                }
                case 2: {
                    string = string + "showground=false;";
                }
            }
        }
        if (this.stereo) {
            string = string + "stereo=" + this.stereo + ";";
        }
        if (this.startPause) {
            string = string + "startpaused=" + this.startPause + ";";
        }
        if (this.mousePause) {
            string = string + "mousepause=" + this.mousePause + ";";
        }
        if (this.catchSound) {
            string = string + "catchsound=" + this.catchSound + ";";
        }
        if (this.bounceSound != bounceSound_def) {
            string = string + "bouncesound=" + this.bounceSound + ";";
        }
        if (this.camangle != null) {
            string = string + "camangle=(" + this.camangle[0] + "," + this.camangle[1] + ");";
        }
        if (this.view != 0) {
            string = string + "view=" + View.viewNames[this.view - 1] + ";";
        }
        if (this.hideJugglers != null) {
            string = string + "hidejugglers=(";
            for (int i = 0; i < this.hideJugglers.length; ++i) {
                string = string + Integer.toString(this.hideJugglers[i]);
                if (i == this.hideJugglers.length - 1) continue;
                string = string + ",";
            }
            string = string + ");";
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static {
        bounceSound_def = !JugglingLab.isLinux;
        double d = 0.0;
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            if (graphicsDeviceArray.length > 0) {
                d = graphicsDeviceArray[0].getDisplayMode().getRefreshRate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        fps_def = d < 20.0 ? 60.0 : d;
    }
}

