/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.ResourceBundle;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class AnimationPanel
extends JPanel
implements Runnable {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    static final double snapangle = Math.toRadians(8.0);
    protected Animator anim = new Animator();
    protected AnimationPrefs jc = new AnimationPrefs();
    protected Thread engine;
    protected boolean engineRunning = false;
    protected boolean enginePaused = false;
    protected boolean engineAnimating = false;
    protected double sim_time;
    public boolean writingGIF = false;
    public String message;
    protected Clip catchclip;
    protected Clip bounceclip;
    protected boolean waspaused = false;
    protected boolean outside = true;
    protected boolean outside_valid = false;
    protected boolean cameradrag = false;
    protected int startx;
    protected int starty;
    protected int lastx;
    protected int lasty;
    protected double[] dragcamangle;
    protected Dimension prefsize;

    public AnimationPanel() {
        this.setOpaque(true);
        this.loadAudioClips();
        this.initHandlers();
    }

    public void setAnimationPanelPreferredSize(Dimension dimension) {
        this.prefsize = dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefsize != null) {
            return new Dimension(this.prefsize);
        }
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    protected void loadAudioClips() {
        DataLine.Info info;
        AudioInputStream audioInputStream;
        URL uRL;
        try {
            uRL = AnimationPanel.class.getResource("/catch.au");
            audioInputStream = AudioSystem.getAudioInputStream(uRL);
            info = new DataLine.Info(Clip.class, audioInputStream.getFormat());
            this.catchclip = (Clip)AudioSystem.getLine(info);
            this.catchclip.open(audioInputStream);
        }
        catch (Exception exception) {
            this.catchclip = null;
        }
        try {
            uRL = AnimationPanel.class.getResource("/bounce.au");
            audioInputStream = AudioSystem.getAudioInputStream(uRL);
            info = new DataLine.Info(Clip.class, audioInputStream.getFormat());
            this.bounceclip = (Clip)AudioSystem.getLine(info);
            this.bounceclip.open(audioInputStream);
        }
        catch (Exception exception) {
            this.bounceclip = null;
        }
    }

    protected void initHandlers() {
        this.addMouseListener(new MouseAdapter(){
            long lastpress = 0L;
            long lastenter = 1L;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.lastpress = mouseEvent.getWhen();
                if (AnimationPanel.this.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (!AnimationPanel.this.engineAnimating) {
                    return;
                }
                if (AnimationPanel.this.writingGIF) {
                    return;
                }
                AnimationPanel.this.startx = mouseEvent.getX();
                AnimationPanel.this.starty = mouseEvent.getY();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (AnimationPanel.this.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (AnimationPanel.this.writingGIF) {
                    return;
                }
                AnimationPanel.this.cameradrag = false;
                if (!AnimationPanel.this.engineAnimating && AnimationPanel.this.engine != null && AnimationPanel.this.engine.isAlive()) {
                    AnimationPanel.this.setPaused(!AnimationPanel.this.enginePaused);
                    return;
                }
                if (mouseEvent.getX() == AnimationPanel.this.startx && mouseEvent.getY() == AnimationPanel.this.starty && AnimationPanel.this.engine != null && AnimationPanel.this.engine.isAlive()) {
                    AnimationPanel.this.setPaused(!AnimationPanel.this.enginePaused);
                    AnimationPanel.this.getParent().dispatchEvent(mouseEvent);
                }
                if (AnimationPanel.this.getPaused()) {
                    AnimationPanel.this.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.lastenter = mouseEvent.getWhen();
                if (AnimationPanel.this.jc.mousePause && !AnimationPanel.this.writingGIF) {
                    AnimationPanel.this.setPaused(AnimationPanel.this.waspaused);
                }
                AnimationPanel.this.outside = false;
                AnimationPanel.this.outside_valid = true;
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (AnimationPanel.this.jc.mousePause && !AnimationPanel.this.writingGIF) {
                    AnimationPanel.this.waspaused = AnimationPanel.this.getPaused();
                    AnimationPanel.this.setPaused(true);
                }
                AnimationPanel.this.outside = true;
                AnimationPanel.this.outside_valid = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!AnimationPanel.this.engineAnimating) {
                    return;
                }
                if (AnimationPanel.this.writingGIF) {
                    return;
                }
                if (!AnimationPanel.this.cameradrag) {
                    AnimationPanel.this.cameradrag = true;
                    AnimationPanel.this.lastx = AnimationPanel.this.startx;
                    AnimationPanel.this.lasty = AnimationPanel.this.starty;
                    AnimationPanel.this.dragcamangle = AnimationPanel.this.getCameraAngle();
                }
                int n = mouseEvent.getX() - AnimationPanel.this.lastx;
                int n2 = mouseEvent.getY() - AnimationPanel.this.lasty;
                AnimationPanel.this.lastx = mouseEvent.getX();
                AnimationPanel.this.lasty = mouseEvent.getY();
                double[] dArray = AnimationPanel.this.dragcamangle;
                dArray[0] = dArray[0] + (double)n * 0.02;
                dArray[1] = dArray[1] - (double)n2 * 0.02;
                if (dArray[1] < Math.toRadians(1.0E-4)) {
                    dArray[1] = Math.toRadians(1.0E-4);
                }
                if (dArray[1] > Math.toRadians(179.9999)) {
                    dArray[1] = Math.toRadians(179.9999);
                }
                while (dArray[0] < 0.0) {
                    dArray[0] = dArray[0] + Math.toRadians(360.0);
                }
                while (dArray[0] >= Math.toRadians(360.0)) {
                    dArray[0] = dArray[0] - Math.toRadians(360.0);
                }
                double[] dArray2 = AnimationPanel.this.snapCamera(dArray);
                AnimationPanel.this.setCameraAngle(dArray2);
                AnimationPanel.this.getParent().dispatchEvent(mouseEvent);
                if (AnimationPanel.this.getPaused()) {
                    AnimationPanel.this.repaint();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!AnimationPanel.this.engineAnimating) {
                    return;
                }
                if (AnimationPanel.this.writingGIF) {
                    return;
                }
                AnimationPanel.this.anim.setDimension(AnimationPanel.this.getSize());
                AnimationPanel.this.repaint();
            }
        });
    }

    protected double[] snapCamera(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], dArray[1]};
        if (dArray2[1] < snapangle) {
            dArray2[1] = Math.toRadians(1.0E-4);
        } else if (this.anglediff(Math.toRadians(90.0) - dArray2[1]) < snapangle) {
            dArray2[1] = Math.toRadians(90.0);
        } else if (dArray2[1] > Math.toRadians(180.0) - snapangle) {
            dArray2[1] = Math.toRadians(179.9999);
        }
        if (this.anim.pat.getNumberOfJugglers() == 1) {
            double d = Math.toRadians(this.anim.pat.getJugglerAngle(1, this.getTime()));
            if (this.anglediff(d - dArray2[0]) < snapangle) {
                dArray2[0] = d;
            } else if (this.anglediff(d + 1.5707963267948966 - dArray2[0]) < snapangle) {
                dArray2[0] = d + 1.5707963267948966;
            } else if (this.anglediff(d + Math.PI - dArray2[0]) < snapangle) {
                dArray2[0] = d + Math.PI;
            } else if (this.anglediff(d + 4.71238898038469 - dArray2[0]) < snapangle) {
                dArray2[0] = d + 4.71238898038469;
            }
        }
        return dArray2;
    }

    protected double anglediff(double d) {
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        while (d <= -Math.PI) {
            d += Math.PI * 2;
        }
        return Math.abs(d);
    }

    public void restartJuggle(JMLPattern jMLPattern, AnimationPrefs animationPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.killAnimationThread();
        if (animationPrefs != null) {
            this.jc = animationPrefs;
        }
        this.anim.setDimension(this.getSize());
        this.anim.restartAnimator(jMLPattern, animationPrefs);
        this.setBackground(this.anim.getBackground());
        this.engine = new Thread(this);
        this.engine.start();
    }

    public void restartJuggle() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.restartJuggle(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        this.engineRunning = true;
        this.engineAnimating = false;
        if (this.jc.mousePause) {
            this.waspaused = this.jc.startPause;
        }
        try {
            if (this.jc.startPause) {
                this.message = guistrings.getString("Message_click_to_start");
                this.repaint();
                this.enginePaused = true;
                while (this.enginePaused) {
                    AnimationPanel animationPanel = this;
                    synchronized (animationPanel) {
                        this.wait();
                    }
                }
            }
            this.message = null;
            long l = System.currentTimeMillis();
            if (this.jc.mousePause) {
                if (this.outside_valid) {
                    this.setPaused(this.outside);
                } else {
                    this.setPaused(true);
                }
                this.waspaused = false;
            }
            this.engineAnimating = true;
            while (true) {
                this.setTime(this.anim.pat.getLoopStartTime());
                int n = 0;
                while (this.getTime() < this.anim.pat.getLoopEndTime() - 0.5 * this.anim.sim_interval_secs) {
                    int n2;
                    Object object;
                    block31: {
                        block32: {
                            block30: {
                                this.repaint();
                                long l2 = this.anim.real_interval_millis - (System.currentTimeMillis() - l);
                                if (l2 <= 0L) break block30;
                                Thread.sleep(l2);
                                break block31;
                            }
                            if (this.engine == null) break block32;
                            AnimationPanel animationPanel = this;
                            if (!animationPanel.engine.interrupted()) break block31;
                        }
                        throw new InterruptedException();
                    }
                    l = System.currentTimeMillis();
                    while (this.enginePaused) {
                        object = this;
                        synchronized (object) {
                            this.wait();
                        }
                    }
                    double d = this.getTime();
                    this.setTime(this.getTime() + this.anim.sim_interval_secs);
                    double d2 = this.getTime();
                    if (this.jc.catchSound && this.catchclip != null) {
                        object = this.anim.pat;
                        synchronized (object) {
                            for (n2 = 1; n2 <= this.anim.pat.getNumberOfPaths(); ++n2) {
                                if (!(this.anim.pat.getPathCatchVolume(n2, d, d2) > 0.0)) continue;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (AnimationPanel.this.catchclip.isActive()) {
                                            AnimationPanel.this.catchclip.stop();
                                        }
                                        AnimationPanel.this.catchclip.setFramePosition(0);
                                        AnimationPanel.this.catchclip.start();
                                    }
                                });
                            }
                        }
                    }
                    if (this.jc.bounceSound && this.bounceclip != null) {
                        object = this.anim.pat;
                        synchronized (object) {
                            for (n2 = 1; n2 <= this.anim.pat.getNumberOfPaths(); ++n2) {
                                if (!(this.anim.pat.getPathBounceVolume(n2, d, d2) > 0.0)) continue;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (AnimationPanel.this.bounceclip.isActive()) {
                                            AnimationPanel.this.bounceclip.stop();
                                        }
                                        AnimationPanel.this.bounceclip.setFramePosition(0);
                                        AnimationPanel.this.bounceclip.start();
                                    }
                                });
                            }
                        }
                    }
                    ++n;
                }
                this.anim.advanceProps();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected void killAnimationThread() {
        try {
            if (this.engine != null && this.engine.isAlive()) {
                this.engine.interrupt();
                this.engine.join();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            this.engine = null;
            this.engineRunning = false;
            this.enginePaused = false;
            this.engineAnimating = false;
            this.message = null;
        }
    }

    public boolean getPaused() {
        return this.enginePaused;
    }

    public synchronized void setPaused(boolean bl) {
        if (this.enginePaused && !bl) {
            this.notify();
        }
        this.enginePaused = bl;
    }

    public double getTime() {
        return this.sim_time;
    }

    public void setTime(double d) {
        this.sim_time = d;
    }

    public double[] getCameraAngle() {
        return this.anim.getCameraAngle();
    }

    public void setCameraAngle(double[] dArray) {
        this.anim.setCameraAngle(dArray);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.message != null) {
            this.drawString(this.message, graphics);
        } else if (this.engineRunning && !this.writingGIF) {
            try {
                this.anim.drawFrame(this.getTime(), graphics, this.cameradrag);
            }
            catch (JuggleExceptionInternal juggleExceptionInternal) {
                this.killAnimationThread();
                System.out.println(juggleExceptionInternal.getMessage());
                System.exit(0);
            }
        }
    }

    protected void drawString(String string, Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        Dimension dimension = this.getSize();
        int n2 = dimension.width > n ? (dimension.width - n) / 2 : 0;
        int n3 = (dimension.height + fontMetrics.getHeight()) / 2;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        graphics.drawString(string, n2, n3);
    }

    public JMLPattern getPattern() {
        return this.anim.pat;
    }

    public Animator getAnimator() {
        return this.anim;
    }

    public AnimationPrefs getAnimationPrefs() {
        return this.jc;
    }

    public void disposeAnimation() {
        this.killAnimationThread();
    }
}

