/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.EditLadderDiagram;
import jugglinglab.core.LadderDiagram;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class AnimationEditPanel
extends AnimationPanel {
    protected LadderDiagram ladder;
    protected boolean event_active = false;
    protected JMLEvent event;
    protected int xlow1;
    protected int xhigh1;
    protected int ylow1;
    protected int yhigh1;
    protected int xlow2;
    protected int xhigh2;
    protected int ylow2;
    protected int yhigh2;
    protected boolean dragging = false;
    protected boolean dragging_left = false;
    protected int xstart;
    protected int ystart;
    protected int xdelta;
    protected int ydelta;

    @Override
    protected void initHandlers() {
        JMLPattern jMLPattern = this.anim.pat;
        this.addMouseListener(new MouseAdapter(){
            long lastpress = 0L;
            long lastenter = 1L;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.lastpress = mouseEvent.getWhen();
                if (AnimationEditPanel.this.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (!AnimationEditPanel.this.engineAnimating) {
                    return;
                }
                if (AnimationEditPanel.this.writingGIF) {
                    return;
                }
                if (AnimationEditPanel.this.event_active) {
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    if (n >= AnimationEditPanel.this.xlow1 && n <= AnimationEditPanel.this.xhigh1 && n2 >= AnimationEditPanel.this.ylow1 && n2 <= AnimationEditPanel.this.yhigh1) {
                        AnimationEditPanel.this.dragging = true;
                        AnimationEditPanel.this.dragging_left = true;
                        AnimationEditPanel.this.xstart = n;
                        AnimationEditPanel.this.ystart = n2;
                        AnimationEditPanel.this.ydelta = 0;
                        AnimationEditPanel.this.xdelta = 0;
                        return;
                    }
                    int n3 = AnimationEditPanel.this.getSize().width / 2;
                    if (n >= AnimationEditPanel.this.xlow2 + n3 && n <= AnimationEditPanel.this.xhigh2 + n3 && n2 >= AnimationEditPanel.this.ylow2 && n2 <= AnimationEditPanel.this.yhigh2) {
                        AnimationEditPanel.this.dragging = true;
                        AnimationEditPanel.this.dragging_left = false;
                        AnimationEditPanel.this.xstart = n;
                        AnimationEditPanel.this.ystart = n2;
                        AnimationEditPanel.this.ydelta = 0;
                        AnimationEditPanel.this.xdelta = 0;
                        return;
                    }
                }
                AnimationEditPanel.this.startx = mouseEvent.getX();
                AnimationEditPanel.this.starty = mouseEvent.getY();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (AnimationEditPanel.this.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (AnimationEditPanel.this.writingGIF) {
                    return;
                }
                if (!AnimationEditPanel.this.engineAnimating && AnimationEditPanel.this.engine != null && AnimationEditPanel.this.engine.isAlive()) {
                    AnimationEditPanel.this.setPaused(!AnimationEditPanel.this.enginePaused);
                    return;
                }
                if (AnimationEditPanel.this.event_active && AnimationEditPanel.this.dragging) {
                    Coordinate coordinate;
                    JMLEvent jMLEvent = AnimationEditPanel.this.event.isMaster() ? AnimationEditPanel.this.event : AnimationEditPanel.this.event.getMaster();
                    boolean bl = AnimationEditPanel.this.event.getHand() != jMLEvent.getHand();
                    Coordinate coordinate2 = AnimationEditPanel.this.anim.ren1.getScreenTranslatedCoordinate(AnimationEditPanel.this.event.getGlobalCoordinate(), AnimationEditPanel.this.xdelta, AnimationEditPanel.this.ydelta);
                    if (AnimationEditPanel.this.jc.stereo) {
                        coordinate = AnimationEditPanel.this.anim.ren2.getScreenTranslatedCoordinate(AnimationEditPanel.this.event.getGlobalCoordinate(), AnimationEditPanel.this.xdelta, AnimationEditPanel.this.ydelta);
                        coordinate2 = Coordinate.add(coordinate2, coordinate);
                        coordinate2.setCoordinate(0.5 * coordinate2.x, 0.5 * coordinate2.y, 0.5 * coordinate2.z);
                    }
                    coordinate = AnimationEditPanel.this.anim.pat.convertGlobalToLocal(coordinate2, AnimationEditPanel.this.event.getJuggler(), AnimationEditPanel.this.event.getT());
                    Coordinate coordinate3 = Coordinate.sub(coordinate, AnimationEditPanel.this.event.getLocalCoordinate());
                    if (bl) {
                        coordinate3.x = -coordinate3.x;
                    }
                    Coordinate coordinate4 = jMLEvent.getLocalCoordinate();
                    jMLEvent.setLocalCoordinate(Coordinate.add(coordinate4, coordinate3));
                    AnimationEditPanel.this.ydelta = 0;
                    AnimationEditPanel.this.xdelta = 0;
                    EditLadderDiagram editLadderDiagram = (EditLadderDiagram)AnimationEditPanel.this.ladder;
                    editLadderDiagram.activeEventMoved();
                }
                AnimationEditPanel.this.cameradrag = false;
                AnimationEditPanel.this.dragging = false;
                if (mouseEvent.getX() == AnimationEditPanel.this.startx && mouseEvent.getY() == AnimationEditPanel.this.starty && AnimationEditPanel.this.engine != null && AnimationEditPanel.this.engine.isAlive()) {
                    AnimationEditPanel.this.setPaused(!AnimationEditPanel.this.enginePaused);
                }
                if (AnimationEditPanel.this.getPaused()) {
                    AnimationEditPanel.this.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.lastenter = mouseEvent.getWhen();
                if (AnimationEditPanel.this.jc.mousePause && !AnimationEditPanel.this.writingGIF) {
                    AnimationEditPanel.this.setPaused(AnimationEditPanel.this.waspaused);
                }
                AnimationEditPanel.this.outside = false;
                AnimationEditPanel.this.outside_valid = true;
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (AnimationEditPanel.this.jc.mousePause && !AnimationEditPanel.this.writingGIF) {
                    AnimationEditPanel.this.waspaused = AnimationEditPanel.this.getPaused();
                    AnimationEditPanel.this.setPaused(true);
                }
                AnimationEditPanel.this.outside = true;
                AnimationEditPanel.this.outside_valid = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                int n2;
                if (!AnimationEditPanel.this.engineAnimating) {
                    return;
                }
                if (AnimationEditPanel.this.writingGIF) {
                    return;
                }
                if (AnimationEditPanel.this.dragging) {
                    n2 = mouseEvent.getX();
                    n = mouseEvent.getY();
                    AnimationEditPanel.this.xdelta = n2 - AnimationEditPanel.this.xstart;
                    AnimationEditPanel.this.ydelta = n - AnimationEditPanel.this.ystart;
                    AnimationEditPanel.this.repaint();
                } else if (!AnimationEditPanel.this.cameradrag) {
                    AnimationEditPanel.this.cameradrag = true;
                    AnimationEditPanel.this.lastx = AnimationEditPanel.this.startx;
                    AnimationEditPanel.this.lasty = AnimationEditPanel.this.starty;
                    AnimationEditPanel.this.dragcamangle = AnimationEditPanel.this.anim.getCameraAngle();
                }
                if (!AnimationEditPanel.this.cameradrag) {
                    return;
                }
                n2 = mouseEvent.getX() - AnimationEditPanel.this.lastx;
                n = mouseEvent.getY() - AnimationEditPanel.this.lasty;
                AnimationEditPanel.this.lastx = mouseEvent.getX();
                AnimationEditPanel.this.lasty = mouseEvent.getY();
                double[] dArray = AnimationEditPanel.this.dragcamangle;
                dArray[0] = dArray[0] + (double)n2 * 0.02;
                dArray[1] = dArray[1] - (double)n * 0.02;
                if (dArray[1] < Math.toRadians(1.0E-4)) {
                    dArray[1] = Math.toRadians(1.0E-4);
                }
                if (dArray[1] > Math.toRadians(179.9999)) {
                    dArray[1] = Math.toRadians(179.9999);
                }
                while (dArray[0] < 0.0) {
                    dArray[0] = dArray[0] + Math.toRadians(360.0);
                }
                while (dArray[0] >= Math.toRadians(360.0)) {
                    dArray[0] = dArray[0] - Math.toRadians(360.0);
                }
                double[] dArray2 = AnimationEditPanel.this.snapCamera(dArray);
                AnimationEditPanel.this.anim.setCameraAngle(dArray2);
                if (AnimationEditPanel.this.event_active) {
                    AnimationEditPanel.this.createEventView();
                }
                if (AnimationEditPanel.this.getPaused()) {
                    AnimationEditPanel.this.repaint();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!AnimationEditPanel.this.engineAnimating) {
                    return;
                }
                if (AnimationEditPanel.this.writingGIF) {
                    return;
                }
                AnimationEditPanel.this.anim.setDimension(AnimationEditPanel.this.getSize());
                if (AnimationEditPanel.this.event_active) {
                    AnimationEditPanel.this.createEventView();
                }
                AnimationEditPanel.this.repaint();
            }
        });
    }

    @Override
    protected double[] snapCamera(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], dArray[1]};
        if (dArray2[1] < snapangle) {
            dArray2[1] = Math.toRadians(1.0E-4);
        } else if (this.anglediff(Math.toRadians(90.0) - dArray2[1]) < snapangle) {
            dArray2[1] = Math.toRadians(90.0);
        } else if (dArray2[1] > Math.toRadians(180.0) - snapangle) {
            dArray2[1] = Math.toRadians(179.9999);
        }
        double d = 0.0;
        boolean bl = true;
        if (this.event_active) {
            d = Math.toRadians(this.anim.pat.getJugglerAngle(this.event.getJuggler(), this.event.getT()));
        } else if (this.anim.pat.getNumberOfJugglers() == 1) {
            d = Math.toRadians(this.anim.pat.getJugglerAngle(1, this.getTime()));
        } else {
            bl = false;
        }
        if (bl) {
            if (this.anglediff(d - dArray2[0]) < snapangle) {
                dArray2[0] = d;
            } else if (this.anglediff(d + 1.5707963267948966 - dArray2[0]) < snapangle) {
                dArray2[0] = d + 1.5707963267948966;
            } else if (this.anglediff(d + Math.PI - dArray2[0]) < snapangle) {
                dArray2[0] = d + Math.PI;
            } else if (this.anglediff(d + 4.71238898038469 - dArray2[0]) < snapangle) {
                dArray2[0] = d + 4.71238898038469;
            }
        }
        return dArray2;
    }

    @Override
    public void restartJuggle(JMLPattern jMLPattern, AnimationPrefs animationPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        super.restartJuggle(jMLPattern, animationPrefs);
        if (this.event_active) {
            this.createEventView();
        }
    }

    public void setLadderDiagram(LadderDiagram ladderDiagram) {
        this.ladder = ladderDiagram;
    }

    @Override
    public void setTime(double d) {
        super.setTime(d);
        if (this.ladder != null) {
            this.ladder.setTime(d);
        }
    }

    public void activateEvent(JMLEvent jMLEvent) {
        if (this.ladder != null && !(this.ladder instanceof EditLadderDiagram)) {
            return;
        }
        this.event = jMLEvent;
        this.event_active = true;
        this.createEventView();
    }

    public void deactivateEvent() {
        this.event_active = false;
    }

    protected void createEventView() {
        if (this.event_active) {
            Coordinate coordinate = this.event.getGlobalCoordinate();
            Coordinate coordinate2 = this.anim.ren1.getScreenTranslatedCoordinate(coordinate, 1, 0);
            Coordinate coordinate3 = Coordinate.sub(coordinate, coordinate2);
            double d = Math.sqrt(coordinate3.x * coordinate3.x + coordinate3.y * coordinate3.y + coordinate3.z * coordinate3.z);
            int n = (int)(0.5 + 5.0 / d);
            int[] nArray = this.anim.ren1.getXY(coordinate);
            this.xlow1 = nArray[0] - n;
            this.ylow1 = nArray[1] - n;
            this.xhigh1 = nArray[0] + n;
            this.yhigh1 = nArray[1] + n;
            if (this.jc.stereo) {
                coordinate = this.event.getGlobalCoordinate();
                coordinate2 = this.anim.ren2.getScreenTranslatedCoordinate(coordinate, 1, 0);
                coordinate3 = Coordinate.sub(coordinate, coordinate2);
                d = Math.sqrt(coordinate3.x * coordinate3.x + coordinate3.y * coordinate3.y + coordinate3.z * coordinate3.z);
                n = (int)(0.5 + 5.0 / d);
                nArray = this.anim.ren2.getXY(coordinate);
                this.xlow2 = nArray[0] - n;
                this.ylow2 = nArray[1] - n;
                this.xhigh2 = nArray[0] + n;
                this.yhigh2 = nArray[1] + n;
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.message != null) {
            this.drawString(this.message, graphics);
        } else if (this.engineRunning && !this.writingGIF) {
            try {
                this.anim.drawFrame(this.getTime(), graphics, this.cameradrag);
                this.drawEvent(graphics);
            }
            catch (JuggleExceptionInternal juggleExceptionInternal) {
                this.killAnimationThread();
                System.out.println(juggleExceptionInternal.getMessage());
                System.exit(0);
            }
        }
    }

    protected void drawEvent(Graphics graphics) throws JuggleExceptionInternal {
        Graphics2D graphics2D;
        if (!this.event_active) {
            return;
        }
        Dimension dimension = this.getSize();
        Graphics graphics2 = graphics;
        if (this.jc.stereo) {
            graphics2 = graphics.create(0, 0, dimension.width / 2, dimension.height);
        }
        if (graphics2 instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics2;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2.setColor(Color.green);
        graphics2.drawLine(this.xlow1 + this.xdelta, this.ylow1 + this.ydelta, this.xhigh1 + this.xdelta, this.ylow1 + this.ydelta);
        graphics2.drawLine(this.xhigh1 + this.xdelta, this.ylow1 + this.ydelta, this.xhigh1 + this.xdelta, this.yhigh1 + this.ydelta);
        graphics2.drawLine(this.xhigh1 + this.xdelta, this.yhigh1 + this.ydelta, this.xlow1 + this.xdelta, this.yhigh1 + this.ydelta);
        graphics2.drawLine(this.xlow1 + this.xdelta, this.yhigh1 + this.ydelta, this.xlow1 + this.xdelta, this.ylow1 + this.ydelta);
        if (this.jc.stereo) {
            graphics2 = graphics.create(dimension.width / 2, 0, dimension.width / 2, dimension.height);
            if (graphics2 instanceof Graphics2D) {
                graphics2D = (Graphics2D)graphics2;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics2.setColor(Color.green);
            graphics2.drawLine(this.xlow2 + this.xdelta, this.ylow2 + this.ydelta, this.xhigh2 + this.xdelta, this.ylow2 + this.ydelta);
            graphics2.drawLine(this.xhigh2 + this.xdelta, this.ylow2 + this.ydelta, this.xhigh2 + this.xdelta, this.yhigh2 + this.ydelta);
            graphics2.drawLine(this.xhigh2 + this.xdelta, this.yhigh2 + this.ydelta, this.xlow2 + this.xdelta, this.yhigh2 + this.ydelta);
            graphics2.drawLine(this.xlow2 + this.xdelta, this.yhigh2 + this.ydelta, this.xlow2 + this.xdelta, this.ylow2 + this.ydelta);
        }
    }
}

