/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab;

import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapGenerator;
import jugglinglab.generator.SiteswapTransitioner;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.SiteswapPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import org.xml.sax.SAXException;

public class JugglingLab {
    public static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    public static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    public static boolean isMacOS;
    public static boolean isWindows;
    public static boolean isLinux;
    public static Path base_dir;
    private static ArrayList<String> jlargs;

    private static String parse_outpath() {
        for (int i = 0; i < jlargs.size(); ++i) {
            if (!jlargs.get(i).equalsIgnoreCase("-out")) continue;
            jlargs.remove(i);
            if (i == jlargs.size()) {
                System.out.println("Warning: no output path specified after -out flag; ignoring");
                return null;
            }
            return jlargs.remove(i);
        }
        return null;
    }

    private static AnimationPrefs parse_animprefs() {
        for (int i = 0; i < jlargs.size(); ++i) {
            if (!jlargs.get(i).equalsIgnoreCase("-prefs")) continue;
            jlargs.remove(i);
            if (i == jlargs.size()) {
                System.out.println("Warning: nothing specified after -prefs flag; ignoring");
                return null;
            }
            try {
                ParameterList parameterList = new ParameterList(jlargs.remove(i));
                AnimationPrefs animationPrefs = new AnimationPrefs().fromParameters(parameterList);
                parameterList.errorIfParametersLeft();
                return animationPrefs;
            }
            catch (JuggleExceptionUser juggleExceptionUser) {
                System.out.println("Error in animator prefs: " + juggleExceptionUser.getMessage() + "; ignoring");
                return null;
            }
        }
        return null;
    }

    private static JMLPattern parse_pattern() {
        if (jlargs.size() == 0) {
            System.out.println("Error: expected pattern input, none found");
            return null;
        }
        if (jlargs.get(0).equalsIgnoreCase("-jml")) {
            jlargs.remove(0);
            if (jlargs.size() == 0) {
                System.out.println("Error: no input path specified after -jml flag");
                return null;
            }
            String string = jlargs.remove(0);
            Path path = Paths.get(string, new String[0]);
            if (!path.isAbsolute() && base_dir != null) {
                path = Paths.get(base_dir.toString(), string);
            }
            try {
                JMLParser jMLParser = new JMLParser();
                jMLParser.parse(new FileReader(path.toFile()));
                switch (jMLParser.getFileType()) {
                    case 1: {
                        return new JMLPattern(jMLParser.getTree());
                    }
                    case 2: {
                        System.out.println("Error: JML file cannot be a pattern list");
                        return null;
                    }
                }
                System.out.println("Error: file is not valid JML");
                return null;
            }
            catch (JuggleExceptionUser juggleExceptionUser) {
                System.out.println("Error parsing JML: " + juggleExceptionUser.getMessage());
                return null;
            }
            catch (SAXException sAXException) {
                System.out.println("Error: formatting error in JML file");
                return null;
            }
            catch (IOException iOException) {
                System.out.println("Error: problem reading JML file from path " + path.toString());
                return null;
            }
        }
        try {
            return new SiteswapPattern().fromString(jlargs.remove(0)).asJMLPattern();
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            System.out.println("Error: " + juggleExceptionUser.getMessage());
        }
        catch (JuggleExceptionInternal juggleExceptionInternal) {
            System.out.println("Internal Error: " + juggleExceptionInternal.getMessage());
        }
        return null;
    }

    public static void main(String[] stringArray) {
        boolean bl;
        if (isMacOS) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        boolean bl2 = true;
        String string = null;
        if (stringArray.length > 0) {
            jlargs = new ArrayList<String>(Arrays.asList(stringArray));
            string = jlargs.remove(0).toLowerCase();
            bl2 = string.equals("start");
        }
        if (bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        new ApplicationWindow("Juggling Lab");
                    }
                    catch (JuggleExceptionUser juggleExceptionUser) {
                        new ErrorDialog(null, juggleExceptionUser.getMessage());
                    }
                    catch (JuggleExceptionInternal juggleExceptionInternal) {
                        ErrorDialog.handleFatalException(juggleExceptionInternal);
                    }
                }
            });
            return;
        }
        List<String> list = Arrays.asList("gen", "trans", "anim", "togif", "tojml");
        boolean bl3 = bl = !list.contains(string);
        if (bl) {
            System.setProperty("java.awt.headless", "true");
            String string2 = guistrings.getString("Version");
            Object[] objectArray = new Object[]{"1.4.1"};
            String string3 = "Juggling Lab " + MessageFormat.format(string2, objectArray).toLowerCase() + "\n";
            string2 = guistrings.getString("Copyright_message");
            Object[] objectArray2 = new Object[]{"2021"};
            string3 = string3 + MessageFormat.format(string2, objectArray2) + "\n";
            string3 = string3 + guistrings.getString("GPL_message") + "\n\n";
            string3 = string3 + guistrings.getString("CLI_help1");
            String string4 = guistrings.getString("CLI_help2");
            if (isWindows) {
                string4 = string4.replaceAll("'", "\"");
            }
            string3 = string3 + string4;
            System.out.println(string3);
            if (string != null && !string.equals("help")) {
                System.out.println("\nUnrecognized option: " + string);
            }
            return;
        }
        String string5 = JugglingLab.parse_outpath();
        Path path = null;
        if (string5 != null && !(path = Paths.get(string5, new String[0])).isAbsolute() && base_dir != null) {
            path = Paths.get(base_dir.toString(), string5);
        }
        AnimationPrefs animationPrefs = JugglingLab.parse_animprefs();
        if (string.equals("gen")) {
            System.setProperty("java.awt.headless", "true");
            String[] stringArray2 = jlargs.toArray(new String[jlargs.size()]);
            try {
                PrintStream printStream = System.out;
                if (path != null) {
                    printStream = new PrintStream(path.toFile());
                }
                SiteswapGenerator.runGeneratorCLI(stringArray2, new GeneratorTarget(printStream));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Error: problem writing to file path " + path.toString());
            }
            if (animationPrefs != null) {
                System.out.println("Note: animator prefs not used in generator mode; ignored");
            }
            return;
        }
        if (string.equals("trans")) {
            System.setProperty("java.awt.headless", "true");
            String[] stringArray3 = jlargs.toArray(new String[jlargs.size()]);
            try {
                PrintStream printStream = System.out;
                if (path != null) {
                    printStream = new PrintStream(path.toFile());
                }
                SiteswapTransitioner.runTransitionerCLI(stringArray3, new GeneratorTarget(printStream));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Error: problem writing to file path " + path.toString());
            }
            if (animationPrefs != null) {
                System.out.println("Note: animator prefs not used in transitions mode; ignored");
            }
            return;
        }
        JMLPattern jMLPattern = JugglingLab.parse_pattern();
        if (jMLPattern == null) {
            return;
        }
        if (jlargs.size() > 0) {
            System.setProperty("java.awt.headless", "true");
            String string6 = String.join((CharSequence)", ", jlargs);
            System.out.println("Error unrecognized input: " + string6);
            return;
        }
        if (string.equals("anim")) {
            final JMLPattern jMLPattern2 = jMLPattern;
            final AnimationPrefs animationPrefs2 = animationPrefs;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        PatternWindow patternWindow = new PatternWindow(jMLPattern2.getTitle(), jMLPattern2, animationPrefs2);
                        patternWindow.setExitOnClose(true);
                    }
                    catch (JuggleExceptionUser juggleExceptionUser) {
                        System.out.println("Error: " + juggleExceptionUser.getMessage());
                    }
                    catch (JuggleExceptionInternal juggleExceptionInternal) {
                        ErrorDialog.handleFatalException(juggleExceptionInternal);
                    }
                }
            });
            return;
        }
        System.setProperty("java.awt.headless", "true");
        if (string.equals("togif")) {
            if (path == null) {
                System.out.println("Error: no output path specified for animated GIF");
                return;
            }
            try {
                Animator animator = new Animator();
                if (animationPrefs == null) {
                    animationPrefs = animator.getAnimationPrefs();
                    animationPrefs.fps = 33.3;
                }
                animator.setDimension(new Dimension(animationPrefs.width, animationPrefs.height));
                animator.restartAnimator(jMLPattern, animationPrefs);
                animator.writeGIF(new FileOutputStream(path.toFile()), null);
            }
            catch (JuggleExceptionUser juggleExceptionUser) {
                System.out.println("Error: " + juggleExceptionUser.getMessage());
            }
            catch (JuggleExceptionInternal juggleExceptionInternal) {
                System.out.println("Internal Error: " + juggleExceptionInternal.getMessage());
            }
            catch (IOException iOException) {
                System.out.println("Error: problem writing GIF to path " + path.toString());
            }
            return;
        }
        if (string.equals("tojml")) {
            if (path == null) {
                System.out.print(jMLPattern.toString());
            } else {
                try {
                    FileWriter fileWriter = new FileWriter(path.toFile());
                    jMLPattern.writeJML(fileWriter, true);
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    System.out.println("Error: problem writing JML to path " + path.toString());
                }
            }
            if (animationPrefs != null) {
                System.out.println("Note: animator prefs not used in jml output mode; ignored");
            }
            return;
        }
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        isMacOS = string.startsWith("mac os x");
        isWindows = string.startsWith("windows");
        isLinux = string.startsWith("linux");
        String string2 = System.getenv("JL_WORKING_DIR");
        if (string2 == null) {
            String string3 = System.getProperty("JL_run_as_bundle");
            string2 = string3 == null || !string3.equals("true") ? System.getProperty("user.dir") : System.getProperty("user.home");
        }
        base_dir = Paths.get(string2, new String[0]);
    }
}

